/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    private static int BUF_SIZE = 50000;
    private static byte[] BUF = new byte[BUF_SIZE];

    public static boolean deleteFile(String path) {
        File file = new File(path);
        return file.delete();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean createFile(String path) throws IOException {
        File file = new File(path);
        if (file.isDirectory()) {
            return file.mkdirs();
        }
        File dir = file.getParentFile();
        dir.mkdirs();
        return file.createNewFile();
    }

    public static void removeRec(File toRemove) {
        if (toRemove.isDirectory()) {
            File[] fileList = toRemove.listFiles();
            for (int a = 0; a < fileList.length; ++a) {
                FileHelper.removeRec(fileList[a]);
            }
        }
        toRemove.delete();
    }

    public static void moveRec(File source, File target) throws IOException {
        byte[] sharedBuffer = new byte[BUF_SIZE];
        FileHelper.moveRec(source, target, sharedBuffer);
    }

    static void moveRec(File source, File target, byte[] sharedBuffer) throws IOException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdirs();
            }
            if (target.isDirectory()) {
                File[] files = source.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    File targetFile = new File(target, file.getName());
                    if (file.isFile()) {
                        if (targetFile.exists()) {
                            targetFile.delete();
                        }
                        if (file.renameTo(targetFile)) continue;
                        FileHelper.copy(file, targetFile, sharedBuffer);
                        file.delete();
                        continue;
                    }
                    if (!targetFile.exists() && !targetFile.mkdirs()) {
                        throw new IOException("Could not create target directory: " + targetFile);
                    }
                    FileHelper.moveRec(file, targetFile);
                }
                source.delete();
            }
        } else if (!target.isDirectory()) {
            FileHelper.copy(source, target, sharedBuffer);
            source.delete();
        }
    }

    public static void copyRec(File source, File target) throws IOException {
        byte[] sharedBuffer = new byte[BUF_SIZE];
        FileHelper.copyRec(source, target, sharedBuffer);
    }

    static void copyRec(File source, File target, byte[] sharedBuffer) throws IOException {
        if (source.isDirectory()) {
            if (!target.exists()) {
                target.mkdirs();
            }
            if (target.isDirectory()) {
                File[] files = source.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    File targetFile = new File(target, file.getName());
                    if (file.isFile()) {
                        if (targetFile.exists()) {
                            targetFile.delete();
                        }
                        FileHelper.copy(file, targetFile, sharedBuffer);
                        continue;
                    }
                    targetFile.mkdirs();
                    FileHelper.copyRec(file, targetFile);
                }
            }
        } else if (!target.isDirectory()) {
            if (!target.exists()) {
                File dir = target.getParentFile();
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new IOException("Could not create target directory: " + dir);
                }
                if (!target.createNewFile()) {
                    throw new IOException("Could not create target file: " + target);
                }
            }
            FileHelper.copy(source, target, sharedBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File input, File output) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(input);
            long l = FileHelper.copy((InputStream)in, output);
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(File input, File output, byte[] copyBuffer) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(input);
            out = new FileOutputStream(output);
            long l = FileHelper.copy(in, out, copyBuffer);
            return l;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream in, File outputFile) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(outputFile);
            long l = FileHelper.copy(in, out);
            return l;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[BUF_SIZE];
        return FileHelper.copy(in, out, buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long globalBufferCopy(InputStream in, OutputStream out) throws IOException {
        byte[] byArray = BUF;
        synchronized (BUF) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return FileHelper.copy(in, out, BUF);
        }
    }

    public static long copy(InputStream in, OutputStream out, byte[] copyBuffer) throws IOException {
        long bytesCopied = 0L;
        int read = -1;
        while ((read = in.read(copyBuffer, 0, copyBuffer.length)) != -1) {
            out.write(copyBuffer, 0, read);
            bytesCopied += (long)read;
        }
        return bytesCopied;
    }
}

