/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.scheduler;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.avalon.cornerstone.services.scheduler.Target;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;

public final class TimeScheduledEntry
implements Comparable {
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat();
    private final String m_name;
    private final TimeTrigger m_trigger;
    private final Target m_target;
    private long m_time;
    private boolean m_isValid;

    public TimeScheduledEntry(String name, TimeTrigger trigger, Target target) {
        this.m_name = name;
        this.m_trigger = trigger;
        this.m_target = target;
        this.m_isValid = true;
    }

    public String getName() {
        return this.m_name;
    }

    public Target getTarget() {
        return this.m_target;
    }

    public TimeTrigger getTimeTrigger() {
        return this.m_trigger;
    }

    public boolean isValid() {
        return this.m_isValid;
    }

    public void invalidate() {
        this.m_isValid = false;
    }

    public long getNextTime() {
        return this.m_time;
    }

    public void setNextTime(long time) {
        this.m_time = time;
    }

    public int compareTo(Object object) {
        TimeScheduledEntry other = (TimeScheduledEntry)object;
        long diff = other.m_time - this.m_time;
        if (diff < 0L) {
            return 1;
        }
        if (diff == 0L) {
            return 0;
        }
        return -1;
    }

    public String toString() {
        return "TimeEntry[ name=" + this.m_name + " valid=" + this.m_isValid + " time=" + DATEFORMAT.format(new Date(this.m_time)) + " ]";
    }
}

