/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.masterstore;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.apache.avalon.cornerstone.services.store.Repository;
import org.apache.avalon.cornerstone.services.store.Store;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class RepositoryManager
extends AbstractLogEnabled
implements Store,
Contextualizable,
Serviceable,
Configurable {
    private static final String REPOSITORY_NAME = "Repository";
    private static long id = 0L;
    protected HashMap m_repositories = new HashMap();
    protected HashMap m_models = new HashMap();
    protected HashMap m_classes = new HashMap();
    protected ServiceManager m_serviceManager;
    protected Context m_context;

    public void contextualize(Context context) {
        this.m_context = context;
    }

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.m_serviceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] registeredClasses = configuration.getChild("repositories").getChildren("repository");
        for (int i = 0; i < registeredClasses.length; ++i) {
            this.registerRepository(registeredClasses[i]);
        }
    }

    public void registerRepository(Configuration repConf) throws ConfigurationException {
        String className = repConf.getAttribute("class");
        this.getLogger().info("Registering Repository " + className);
        Configuration[] protocols = repConf.getChild("protocols").getChildren("protocol");
        Configuration[] types = repConf.getChild("types").getChildren("type");
        Configuration[] modelIterator = repConf.getChild("models").getChildren("model");
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i].getValue();
            for (int j = 0; j < types.length; ++j) {
                String type = types[j].getValue();
                for (int k = 0; k < modelIterator.length; ++k) {
                    String model = modelIterator[k].getValue();
                    this.m_classes.put(protocol + type + model, className);
                    this.getLogger().info("   for " + protocol + "," + type + "," + model);
                }
            }
        }
    }

    public void release(Object service) {
    }

    public boolean isSelectable(Object policy) {
        return policy instanceof Configuration;
    }

    public Object select(Object policy) throws ServiceException {
        Configuration repConf = null;
        try {
            repConf = (Configuration)policy;
        }
        catch (ClassCastException cce) {
            throw new ServiceException(policy.toString(), "Hint is of the wrong type. Must be a Configuration", (Throwable)cce);
        }
        URL destination = null;
        try {
            destination = new URL(repConf.getAttribute("destinationURL"));
        }
        catch (ConfigurationException ce) {
            throw new ServiceException(policy.toString(), "Malformed configuration has no destinationURL attribute", (Throwable)ce);
        }
        catch (MalformedURLException mue) {
            throw new ServiceException(policy.toString(), "destination is malformed. Must be a valid URL", (Throwable)mue);
        }
        try {
            String type = repConf.getAttribute("type");
            String repID = destination + type;
            Repository reply = (Repository)this.m_repositories.get(repID);
            String model = repConf.getAttribute("model");
            if (null != reply) {
                if (this.m_models.get(repID).equals(model)) {
                    return reply;
                }
                String message = "There is already another repository with the same destination and type but with different model";
                throw new ServiceException(policy.toString(), "There is already another repository with the same destination and type but with different model");
            }
            String protocol = destination.getProtocol();
            String repClass = (String)this.m_classes.get(protocol + type + model);
            this.getLogger().debug("Need instance of " + repClass + " to handle: " + protocol + type + model);
            try {
                reply = (Repository)Class.forName(repClass).newInstance();
                this.setupLogger(reply, "repository");
                ContainerUtil.contextualize((Object)reply, (Context)this.m_context);
                ContainerUtil.service((Object)reply, (ServiceManager)this.m_serviceManager);
                ContainerUtil.configure((Object)reply, (Configuration)repConf);
                ContainerUtil.initialize((Object)reply);
                this.m_repositories.put(repID, reply);
                this.m_models.put(repID, model);
                this.getLogger().info("New instance of " + repClass + " created for " + destination);
                return reply;
            }
            catch (Exception e) {
                String message = "Cannot find or init repository: " + e.getMessage();
                this.getLogger().warn(message, (Throwable)e);
                throw new ServiceException(policy.toString(), message, (Throwable)e);
            }
        }
        catch (ConfigurationException ce) {
            throw new ServiceException(policy.toString(), "Malformed configuration", (Throwable)ce);
        }
    }

    public static final String getName() {
        return REPOSITORY_NAME + id++;
    }
}

