/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.blocks.masterstore;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.avalon.cornerstone.blocks.masterstore.AbstractFileRepository;
import org.apache.avalon.cornerstone.blocks.masterstore.ClassLoaderObjectInputStream;
import org.apache.avalon.cornerstone.services.store.ObjectRepository;

public abstract class AbstractFilePersistentObjectRepository
extends AbstractFileRepository
implements ObjectRepository {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(String key) {
        Object object;
        InputStream inputStream = this.getInputStream(key);
        if (inputStream == null) {
            throw new NullPointerException("Null input stream returned for key: " + key);
        }
        try {
            Object object2;
            ObjectInputStream stream = new ObjectInputStream(inputStream);
            if (stream == null) {
                throw new NullPointerException("Null stream returned for key: " + key);
            }
            object = object2 = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception caught while retrieving an object, cause: " + e.toString());
            }
        }
        inputStream.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object get(String key, ClassLoader classLoader) {
        Object object;
        InputStream inputStream = this.getInputStream(key);
        if (inputStream == null) {
            throw new NullPointerException("Null input stream returned for key: " + key);
        }
        try {
            Object object2;
            ClassLoaderObjectInputStream stream = new ClassLoaderObjectInputStream(classLoader, inputStream);
            if (stream == null) {
                throw new NullPointerException("Null stream returned for key: " + key);
            }
            object = object2 = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception caught while retrieving an object: " + e);
            }
        }
        inputStream.close();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(String key, Object value) {
        try {
            OutputStream outputStream = this.getOutputStream(key);
            try {
                ObjectOutputStream stream = new ObjectOutputStream(outputStream);
                stream.writeObject(value);
            }
            finally {
                outputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception caught while storing an object: " + e);
        }
    }

    protected String getExtensionDecorator() {
        return ".FileObjectStore";
    }
}

