/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.cornerstone.threads.tutorial;

import org.apache.avalon.cornerstone.services.threads.ThreadManager;
import org.apache.avalon.cornerstone.threads.tutorial.Counter;
import org.apache.avalon.excalibur.thread.ThreadControl;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class ThreadConsumer
extends AbstractLogEnabled
implements Serviceable,
Initializable,
Disposable {
    private ServiceManager m_manager;
    private ThreadManager m_threads;
    private ThreadPool m_pool;
    private ThreadControl m_control;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.getLogger().info("aquiring cornerstone threads service");
        this.m_threads = (ThreadManager)this.m_manager.lookup("threads");
    }

    public void initialize() throws Exception {
        this.getLogger().info("initialization");
        this.m_pool = this.m_threads.getDefaultThreadPool();
        Counter counter = new Counter();
        counter.enableLogging(this.getLogger().getChildLogger("counter"));
        this.m_control = this.m_pool.execute((Runnable)counter);
    }

    public void dispose() {
        this.getLogger().info("disposal");
        if (this.m_control != null && !this.m_control.isFinished()) {
            this.getLogger().info("disposal invoked while child thread active");
            this.m_control.interrupt();
            while (!this.m_control.isFinished()) {
                this.getLogger().info("waiting for child");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.m_control != null && this.m_control.getThrowable() != null) {
            this.getLogger().warn("thread terminated with exception condition", this.m_control.getThrowable());
        }
        if (this.m_pool != null) {
            if (this.m_pool instanceof Disposable) {
                ((Disposable)this.m_pool).dispose();
            }
            this.m_pool = null;
        }
        this.m_manager.release((Object)this.m_threads);
        this.m_control = null;
        this.m_threads = null;
        this.m_manager = null;
        this.getLogger().info("disposal complete");
    }
}

