/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.CachedEntrySuitabilityChecker;
import cz.jirutka.spring.http.client.cache.CachingPolicy;
import cz.jirutka.spring.http.client.cache.DefaultCachedEntrySuitabilityChecker;
import cz.jirutka.spring.http.client.cache.DefaultCachingPolicy;
import cz.jirutka.spring.http.client.cache.internal.CacheEntry;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseCache;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseCacheImpl;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class CachingHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CachingHttpRequestInterceptor.class);
    private final HttpResponseCache cache;
    private CachingPolicy cachingPolicy;
    private CachedEntrySuitabilityChecker cachedChecker;

    public CachingHttpRequestInterceptor(Cache cache, boolean sharedCache, int maxResponseSize) {
        this.cache = new HttpResponseCacheImpl(cache, sharedCache, maxResponseSize);
        this.cachingPolicy = new DefaultCachingPolicy(sharedCache, maxResponseSize);
        this.cachedChecker = new DefaultCachedEntrySuitabilityChecker();
    }

    public CachingHttpRequestInterceptor(HttpResponseCache cache, CachingPolicy cachingPolicy, CachedEntrySuitabilityChecker cachedChecker) {
        this.cache = cache;
        this.cachingPolicy = cachingPolicy;
        this.cachedChecker = cachedChecker;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (!this.cachingPolicy.isServableFromCache(request)) {
            this.log("not servable from cache", request);
            return this.execute(request, body, execution);
        }
        CacheEntry entry = this.cache.getCacheEntry(request);
        if (entry == null || !this.cachedChecker.canCachedEntryBeUsed(request, entry, this.currentDate())) {
            this.log("cache miss", request);
            return this.execute(request, body, execution);
        }
        this.log("cache hit", request);
        return this.createResponse(entry);
    }

    protected ClientHttpResponse execute(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        Date requestDate = this.currentDate();
        ClientHttpResponse response = execution.execute(request, body);
        if (this.cachingPolicy.isResponseCacheable(request, response)) {
            this.log("caching response", request);
            return this.cache.cacheAndReturnResponse(request, response, requestDate, this.currentDate());
        }
        this.log("response is not cacheable", request);
        return response;
    }

    protected ClientHttpResponse createResponse(CacheEntry entry) {
        ClientHttpResponse response = entry.getResponse();
        Long age = (this.currentDate().getTime() - entry.getResponseCreated().getTime()) / 1000L;
        response.getHeaders().set("Age", age.toString());
        return response;
    }

    private void log(String message, HttpRequest request) {
        log.debug("[{} {}] {}", new Object[]{request.getMethod(), request.getURI(), message});
    }

    private Date currentDate() {
        return new Date();
    }

    public HttpResponseCache getCache() {
        return this.cache;
    }

    public CachingPolicy getCachingPolicy() {
        return this.cachingPolicy;
    }

    public CachedEntrySuitabilityChecker getCachedChecker() {
        return this.cachedChecker;
    }

    public void setCachingPolicy(CachingPolicy cachingPolicy) {
        this.cachingPolicy = cachingPolicy;
    }

    public void setCachedChecker(CachedEntrySuitabilityChecker cachedChecker) {
        this.cachedChecker = cachedChecker;
    }
}

