/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.CachingHttpRequestInterceptor;
import cz.jirutka.spring.http.client.cache.CachingPolicy;
import cz.jirutka.spring.http.client.cache.DefaultCachedEntrySuitabilityChecker;
import cz.jirutka.spring.http.client.cache.DefaultCachingPolicy;
import cz.jirutka.spring.http.client.cache.SoftReferenceSynchronizedLruCache;
import cz.jirutka.spring.http.client.cache.SynchronizedLruCache;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseCacheImpl;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public final class CachingHttpRequestInterceptorBuilder {
    private final CachingHttpRequestInterceptorBuilder parent = this;
    private boolean sharedCache = true;
    private int maxResponseSize = 131072;
    private CachingPolicy cachingPolicy;
    private Cache cache;

    public InMemoryCacheBuilder inMemoryCache() {
        Assert.isNull((Object)this.cache, (String)"You cannot use both custom cache and built-in inMemoryCache");
        return new InMemoryCacheBuilder();
    }

    public CachingHttpRequestInterceptor build() {
        if (this.cachingPolicy == null) {
            this.cachingPolicy = new DefaultCachingPolicy(this.sharedCache, this.maxResponseSize);
        }
        Assert.notNull((Object)this.cache, (String)"You must specify cache backend, or use inMemoryCache ");
        HttpResponseCacheImpl responseCache = new HttpResponseCacheImpl(this.cache, this.sharedCache, this.maxResponseSize);
        return new CachingHttpRequestInterceptor(responseCache, this.cachingPolicy, new DefaultCachedEntrySuitabilityChecker());
    }

    public void enhance(RestTemplate restTemplate) {
        restTemplate.getInterceptors().add(this.build());
    }

    public CachingHttpRequestInterceptorBuilder sharedCache(boolean sharedCache) {
        this.sharedCache = sharedCache;
        return this;
    }

    public CachingHttpRequestInterceptorBuilder maxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        return this;
    }

    public CachingHttpRequestInterceptorBuilder cachingPolicy(CachingPolicy cachingPolicy) {
        this.cachingPolicy = cachingPolicy;
        return this;
    }

    public CachingHttpRequestInterceptorBuilder cache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public final class InMemoryCacheBuilder {
        private int capacity = 64;
        private boolean softReferences = true;

        public CachingHttpRequestInterceptor build() {
            CachingHttpRequestInterceptorBuilder.this.parent.cache = this.softReferences ? new SoftReferenceSynchronizedLruCache("http-cache", this.capacity) : new SynchronizedLruCache("http-cache", this.capacity);
            return CachingHttpRequestInterceptorBuilder.this.parent.build();
        }

        public void enhance(RestTemplate restTemplate) {
            restTemplate.getInterceptors().add(this.build());
        }

        public InMemoryCacheBuilder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public InMemoryCacheBuilder softReferences(boolean softReferences) {
            this.softReferences = softReferences;
            return this;
        }
    }
}

