/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.CachedEntrySuitabilityChecker;
import cz.jirutka.spring.http.client.cache.internal.CacheControl;
import cz.jirutka.spring.http.client.cache.internal.CacheEntry;
import java.util.Date;
import net.jcip.annotations.Immutable;
import org.springframework.http.HttpRequest;

@Immutable
public class DefaultCachedEntrySuitabilityChecker
implements CachedEntrySuitabilityChecker {
    @Override
    public boolean canCachedEntryBeUsed(HttpRequest request, CacheEntry entry, Date now) {
        if (now.after(entry.getResponseExpiration())) {
            return false;
        }
        CacheControl cc = CacheControl.parseCacheControl(request.getHeaders());
        return cc.getMaxAge() <= -1 || this.responseCurrentAge(entry, now) <= (long)cc.getMaxAge();
    }

    private long responseCurrentAge(CacheEntry entry, Date now) {
        return (now.getTime() - entry.getResponseCreated().getTime()) / 1000L;
    }
}

