/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.CachingPolicy;
import cz.jirutka.spring.http.client.cache.internal.CacheControl;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;

@Immutable
public class DefaultCachingPolicy
implements CachingPolicy {
    private static final Logger log = LoggerFactory.getLogger(DefaultCachingPolicy.class);
    private static final Set<HttpMethod> CACHEABLE_METHODS = EnumSet.of(HttpMethod.GET);
    private static final Set<Integer> CACHEABLE_STATUSES = new HashSet<Integer>(Arrays.asList(200, 203, 300, 301, 410));
    private static final Set<Integer> UNCACHEABLE_STATUSES = new HashSet<Integer>(Arrays.asList(206, 303));
    private final long maxBodySizeBytes;
    private final boolean sharedCache;

    public DefaultCachingPolicy(boolean sharedCache) {
        this(sharedCache, Long.MAX_VALUE);
    }

    public DefaultCachingPolicy(boolean sharedCache, long maxBodySizeBytes) {
        this.sharedCache = sharedCache;
        this.maxBodySizeBytes = maxBodySizeBytes > 0L ? maxBodySizeBytes : Long.MAX_VALUE;
    }

    @Override
    public boolean isResponseCacheable(HttpRequest request, ClientHttpResponse response) {
        CacheControl cc;
        HttpHeaders reqHeaders = request.getHeaders();
        HttpHeaders respHeaders = response.getHeaders();
        if (!this.isCacheableMethod(request.getMethod())) {
            log.trace("Not cacheable: method {}", (Object)request.getMethod());
            return false;
        }
        if (CacheControl.parseCacheControl(reqHeaders).isNoStore()) {
            log.trace("Not cacheable: request has Cache-Control: no-store");
            return false;
        }
        if (this.sharedCache && reqHeaders.getFirst("Authorization") != null && !(cc = CacheControl.parseCacheControl(respHeaders)).isPublic() && cc.getSMaxAge() <= 0) {
            log.trace("Not cacheable: this cache is shared and request contains Authorization header, but no Cache-Control: public");
            return false;
        }
        return this.isResponseCacheable(response);
    }

    @Override
    public boolean isServableFromCache(HttpRequest request) {
        if (!this.isCacheableMethod(request.getMethod())) {
            log.trace("Request with method {} is not serveable from cache", (Object)request.getMethod());
            return false;
        }
        CacheControl cc = CacheControl.parseCacheControl(request.getHeaders());
        if (cc.isNoStore()) {
            log.trace("Request with no-store is not serveable from cache");
            return false;
        }
        if (cc.isNoCache()) {
            log.trace("Request with no-cache is not serveable from cache");
            return false;
        }
        return true;
    }

    protected boolean isResponseCacheable(ClientHttpResponse response) {
        boolean cacheable = false;
        HttpHeaders headers = response.getHeaders();
        try {
            int status = response.getRawStatusCode();
            if (this.isImplicitlyCacheableStatus(status)) {
                cacheable = true;
            } else if (this.isUncacheableStatus(status)) {
                log.trace("Response with status code {} is not cacheable", (Object)status);
                return false;
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        if (this.isExplicitlyNonCacheable(response)) {
            log.trace("Response with Cache-Control: '{}' is not cacheable", (Object)headers.getCacheControl());
            return false;
        }
        if (headers.getContentLength() > this.maxBodySizeBytes) {
            log.debug("Response with Content-Lenght {} > {} is not cacheable", (Object)headers.getContentLength(), (Object)this.maxBodySizeBytes);
            return false;
        }
        try {
            if (response.getHeaders().getDate() < 0L) {
                log.debug("Response without a valid Date header is not cacheable");
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        if (headers.containsKey((Object)"Vary")) {
            log.trace("Response with Vary header is not cacheable");
            return false;
        }
        return cacheable || this.isExplicitlyCacheable(response);
    }

    protected boolean isImplicitlyCacheableStatus(int status) {
        return CACHEABLE_STATUSES.contains(status);
    }

    protected boolean isUncacheableStatus(int status) {
        return UNCACHEABLE_STATUSES.contains(status) || this.isUnknownStatus(status);
    }

    protected boolean isUnknownStatus(int status) {
        return !(status >= 100 && status <= 101 || status >= 200 && status <= 206 || status >= 300 && status <= 307 || status >= 400 && status <= 417 || status >= 500 && status <= 505);
    }

    protected boolean isCacheableMethod(HttpMethod method) {
        return CACHEABLE_METHODS.contains(method);
    }

    protected boolean isExplicitlyNonCacheable(ClientHttpResponse response) {
        CacheControl cc = CacheControl.parseCacheControl(response.getHeaders());
        return cc.isNoStore() || cc.isNoCache() || this.sharedCache && cc.isPrivate() || cc.getMaxAge(this.sharedCache) == 0;
    }

    protected boolean isExplicitlyCacheable(ClientHttpResponse response) {
        CacheControl cc = CacheControl.parseCacheControl(response.getHeaders());
        return cc.isPublic() || cc.isMustRevalidate() || cc.isProxyRevalidate() || cc.getMaxAge(this.sharedCache) > 0;
    }
}

