/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.ResponseExpirationResolver;
import cz.jirutka.spring.http.client.cache.internal.CacheControl;
import java.util.Date;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpResponse;

@Immutable
public class DefaultResponseExpirationResolver
implements ResponseExpirationResolver {
    public static final long MAX_AGE = 0x80000000L;
    private final boolean sharedCache;

    public DefaultResponseExpirationResolver() {
        this(true);
    }

    public DefaultResponseExpirationResolver(boolean sharedCache) {
        this.sharedCache = sharedCache;
    }

    @Override
    public Date resolveExpirationDate(ClientHttpResponse response, Date correctedInitialDate) {
        long maxAge = (long)this.parseMaxAgeHeader(response.getHeaders()) * 1000L;
        return new Date(correctedInitialDate.getTime() + maxAge);
    }

    @Override
    public Date resolveInitialDate(ClientHttpResponse response, Date requestDate, Date responseDate) {
        long age = this.correctedInitialAge(response, requestDate, responseDate) * 1000L;
        return new Date(responseDate.getTime() + age);
    }

    public long correctedInitialAge(ClientHttpResponse response, Date requestDate, Date responseDate) {
        long ageValue = this.parseAgeHeader(response.getHeaders());
        long headerDate = response.getHeaders().getDate();
        long apparentAge = Math.max(0L, responseDate.getTime() - headerDate) / 1000L;
        long correctedReceivedAge = Math.max(apparentAge, ageValue);
        long responseDelay = (responseDate.getTime() - requestDate.getTime()) / 1000L;
        return correctedReceivedAge + responseDelay;
    }

    long parseAgeHeader(HttpHeaders headers) {
        long result = 0L;
        if (!headers.containsKey((Object)"Age")) {
            return result;
        }
        for (String value : headers.get((Object)"Age")) {
            long age = NumberUtils.toLong((String)value, (long)0x80000000L);
            if (age < 0L) {
                age = 0x80000000L;
            }
            result = Math.max(result, age);
        }
        return result;
    }

    private int parseMaxAgeHeader(HttpHeaders headers) {
        CacheControl cc = CacheControl.valueOf(headers.getCacheControl());
        return cc.getMaxAge(this.sharedCache);
    }
}

