/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import cz.jirutka.spring.http.client.cache.SynchronizedLruCache;
import java.lang.ref.SoftReference;
import net.jcip.annotations.ThreadSafe;
import org.springframework.cache.Cache;

@ThreadSafe
public class SoftReferenceSynchronizedLruCache
extends SynchronizedLruCache {
    public SoftReferenceSynchronizedLruCache(String name, int capacity) {
        super(name, capacity);
    }

    public SoftReferenceSynchronizedLruCache(String name, int capacity, int initialCapacity, float loadFactory) {
        super(name, capacity, initialCapacity, loadFactory);
    }

    @Override
    public synchronized Cache.ValueWrapper get(Object key) {
        Cache.ValueWrapper wrapped = super.get(key);
        if (wrapped != null && wrapped.get() == null) {
            this.evict(key);
        }
        return wrapped;
    }

    @Override
    protected Cache.ValueWrapper createEntry(Object value) {
        return new SoftReferenceWrapper(value);
    }

    static class SoftReferenceWrapper
    implements Cache.ValueWrapper {
        private final SoftReference<Object> value;

        SoftReferenceWrapper(Object value) {
            this.value = new SoftReference<Object>(value);
        }

        public Object get() {
            return this.value.get();
        }
    }
}

