/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.util.Assert;

@ThreadSafe
public class SynchronizedLruCache
implements Cache {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final String name;
    private final int capacity;
    private final LinkedHashMap<Object, Cache.ValueWrapper> store;

    public SynchronizedLruCache(String name, int capacity) {
        this(name, capacity, 16 > capacity ? capacity : 16, 0.75f);
    }

    public SynchronizedLruCache(String name, int capacity, int initialCapacity, float loadFactory) {
        Assert.hasText((String)name, (String)"name should not be blank");
        Assert.isTrue((capacity > 0 ? 1 : 0) != 0, (String)"capacity must be greater then 0");
        this.name = name;
        this.capacity = capacity;
        this.store = new LinkedHashMap<Object, Cache.ValueWrapper>(initialCapacity, loadFactory, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > SynchronizedLruCache.this.capacity;
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public LinkedHashMap getNativeCache() {
        return this.store;
    }

    public synchronized Cache.ValueWrapper get(Object key) {
        return this.store.get(key);
    }

    public synchronized void put(Object key, Object value) {
        Assert.notNull((Object)value, (String)"value must not be null");
        this.store.put(key, this.createEntry(value));
    }

    public synchronized void evict(Object key) {
        this.store.remove(key);
    }

    public synchronized void clear() {
        this.store.clear();
    }

    protected Cache.ValueWrapper createEntry(Object value) {
        return new SimpleValueWrapper(value);
    }
}

