/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public class CacheControl {
    private static final Pattern PATTERN = Pattern.compile("\\s*([\\w\\-]+)\\s*(=)?\\s*(\\-?\\d+|\\\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)+\\\")?\\s*");
    private int maxAge = -1;
    private int sMaxAge = -1;
    private boolean isMustRevalidate = false;
    private boolean isNoCache = false;
    private boolean isNoStore = false;
    private boolean isNoTransform = false;
    private boolean isPrivate = false;
    private boolean isPublic = false;
    private boolean isProxyRevalidate = false;

    public static CacheControl valueOf(String value) {
        CacheControl cc;
        block32: {
            cc = new CacheControl();
            if (value == null) break block32;
            Matcher matcher = PATTERN.matcher(value);
            while (matcher.find()) {
                switch (matcher.group(1).toLowerCase()) {
                    case "max-age": {
                        cc.setMaxAge(Integer.parseInt(matcher.group(3)));
                        break;
                    }
                    case "s-maxage": {
                        cc.setSMaxAge(Integer.parseInt(matcher.group(3)));
                        break;
                    }
                    case "must-revalidate": {
                        cc.setMustRevalidate(true);
                        break;
                    }
                    case "no-cache": {
                        cc.setNoCache(true);
                        break;
                    }
                    case "no-store": {
                        cc.setNoStore(true);
                        break;
                    }
                    case "no-transform": {
                        cc.setNoTransform(true);
                        break;
                    }
                    case "private": {
                        cc.setPrivate(true);
                        break;
                    }
                    case "public": {
                        cc.setPublic(true);
                        break;
                    }
                    case "proxy-revalidate": {
                        cc.setProxyRevalidate(true);
                    }
                }
            }
        }
        return cc;
    }

    public static CacheControl parseCacheControl(HttpHeaders headers) {
        Assert.notNull((Object)headers, (String)"headers must not be null");
        return CacheControl.valueOf(headers.getCacheControl());
    }

    public int getMaxAge(boolean sharedCache) {
        if (sharedCache) {
            return this.sMaxAge >= 0 ? this.sMaxAge : this.maxAge;
        }
        return this.maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public int getSMaxAge() {
        return this.sMaxAge;
    }

    public boolean isMustRevalidate() {
        return this.isMustRevalidate;
    }

    public boolean isNoCache() {
        return this.isNoCache;
    }

    public boolean isNoStore() {
        return this.isNoStore;
    }

    public boolean isNoTransform() {
        return this.isNoTransform;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isProxyRevalidate() {
        return this.isProxyRevalidate;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public void setSMaxAge(int sMaxAge) {
        this.sMaxAge = sMaxAge;
    }

    public void setMustRevalidate(boolean isMustRevalidate) {
        this.isMustRevalidate = isMustRevalidate;
    }

    public void setNoCache(boolean isNoCache) {
        this.isNoCache = isNoCache;
    }

    public void setNoStore(boolean isNoStore) {
        this.isNoStore = isNoStore;
    }

    public void setNoTransform(boolean isNoTransform) {
        this.isNoTransform = isNoTransform;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setProxyRevalidate(boolean isProxyRevalidate) {
        this.isProxyRevalidate = isProxyRevalidate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheControl)) {
            return false;
        }
        CacheControl other = (CacheControl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxAge() != other.getMaxAge()) {
            return false;
        }
        if (this.getSMaxAge() != other.getSMaxAge()) {
            return false;
        }
        if (this.isMustRevalidate() != other.isMustRevalidate()) {
            return false;
        }
        if (this.isNoCache() != other.isNoCache()) {
            return false;
        }
        if (this.isNoStore() != other.isNoStore()) {
            return false;
        }
        if (this.isNoTransform() != other.isNoTransform()) {
            return false;
        }
        if (this.isPrivate() != other.isPrivate()) {
            return false;
        }
        if (this.isPublic() != other.isPublic()) {
            return false;
        }
        return this.isProxyRevalidate() == other.isProxyRevalidate();
    }

    public boolean canEqual(Object other) {
        return other instanceof CacheControl;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + this.getMaxAge();
        result = result * 31 + this.getSMaxAge();
        result = result * 31 + (this.isMustRevalidate() ? 1231 : 1237);
        result = result * 31 + (this.isNoCache() ? 1231 : 1237);
        result = result * 31 + (this.isNoStore() ? 1231 : 1237);
        result = result * 31 + (this.isNoTransform() ? 1231 : 1237);
        result = result * 31 + (this.isPrivate() ? 1231 : 1237);
        result = result * 31 + (this.isPublic() ? 1231 : 1237);
        result = result * 31 + (this.isProxyRevalidate() ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return "CacheControl(maxAge=" + this.getMaxAge() + ", sMaxAge=" + this.getSMaxAge() + ", isMustRevalidate=" + this.isMustRevalidate() + ", isNoCache=" + this.isNoCache() + ", isNoStore=" + this.isNoStore() + ", isNoTransform=" + this.isNoTransform() + ", isPrivate=" + this.isPrivate() + ", isPublic=" + this.isPublic() + ", isProxyRevalidate=" + this.isProxyRevalidate() + ")";
    }
}

