/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import cz.jirutka.spring.http.client.cache.internal.InMemoryClientHttpResponse;
import java.io.Serializable;
import java.util.Date;
import net.jcip.annotations.Immutable;
import org.springframework.http.client.ClientHttpResponse;

@Immutable
public class CacheEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final InMemoryClientHttpResponse response;
    private final Date responseCreated;
    private final Date responseExpiration;

    public CacheEntry(InMemoryClientHttpResponse response, Date responseCreated, Date responseExpiration) {
        this.response = response;
        this.responseCreated = responseCreated;
        this.responseExpiration = responseExpiration;
    }

    public ClientHttpResponse getResponse() {
        return this.response.deepCopy();
    }

    public Date getResponseCreated() {
        return new Date(this.responseCreated.getTime());
    }

    public Date getResponseExpiration() {
        return new Date(this.responseExpiration.getTime());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheEntry)) {
            return false;
        }
        CacheEntry other = (CacheEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClientHttpResponse this$response = this.getResponse();
        ClientHttpResponse other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        Date this$responseCreated = this.getResponseCreated();
        Date other$responseCreated = other.getResponseCreated();
        if (this$responseCreated == null ? other$responseCreated != null : !((Object)this$responseCreated).equals(other$responseCreated)) {
            return false;
        }
        Date this$responseExpiration = this.getResponseExpiration();
        Date other$responseExpiration = other.getResponseExpiration();
        return !(this$responseExpiration == null ? other$responseExpiration != null : !((Object)this$responseExpiration).equals(other$responseExpiration));
    }

    public boolean canEqual(Object other) {
        return other instanceof CacheEntry;
    }

    public int hashCode() {
        int result = 1;
        ClientHttpResponse $response = this.getResponse();
        result = result * 31 + ($response == null ? 0 : $response.hashCode());
        Date $responseCreated = this.getResponseCreated();
        result = result * 31 + ($responseCreated == null ? 0 : ((Object)$responseCreated).hashCode());
        Date $responseExpiration = this.getResponseExpiration();
        result = result * 31 + ($responseExpiration == null ? 0 : ((Object)$responseExpiration).hashCode());
        return result;
    }
}

