/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

@NotThreadSafe
public class CombinedClientHttpResponse
implements ClientHttpResponse {
    private final ClientHttpResponse response;
    private final InputStream body;

    public CombinedClientHttpResponse(ClientHttpResponse response, InputStream body) {
        Assert.notNull((Object)response, (String)"response must not be null");
        this.response = response;
        this.body = body;
    }

    public InputStream getBody() throws IOException {
        return this.body;
    }

    public HttpHeaders getHeaders() {
        return this.response.getHeaders();
    }

    public void close() {
        this.response.close();
    }

    public int getRawStatusCode() throws IOException {
        return this.response.getRawStatusCode();
    }

    public HttpStatus getStatusCode() throws IOException {
        return this.response.getStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.response.getStatusText();
    }
}

