/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import cz.jirutka.spring.http.client.cache.CacheKeyGenerator;
import cz.jirutka.spring.http.client.cache.DefaultResponseExpirationResolver;
import cz.jirutka.spring.http.client.cache.ResponseExpirationResolver;
import cz.jirutka.spring.http.client.cache.SimpleCacheKeyGenerator;
import cz.jirutka.spring.http.client.cache.internal.CacheEntry;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseCache;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseReader;
import cz.jirutka.spring.http.client.cache.internal.InMemoryClientHttpResponse;
import cz.jirutka.spring.http.client.cache.internal.SizeLimitedHttpResponseReader;
import java.io.IOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class HttpResponseCacheImpl
implements HttpResponseCache {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseCacheImpl.class);
    private final Cache cache;
    private final CacheKeyGenerator keyGenerator;
    private ResponseExpirationResolver expirationResolver;
    private HttpResponseReader responseReader;

    public HttpResponseCacheImpl(Cache cache, boolean sharedCache, int maxResponseSize) {
        this(cache, sharedCache, maxResponseSize, new SimpleCacheKeyGenerator());
    }

    public HttpResponseCacheImpl(Cache cache, boolean sharedCache, int maxResponseSize, CacheKeyGenerator keyGenerator) {
        this.cache = cache;
        this.keyGenerator = keyGenerator;
        this.expirationResolver = new DefaultResponseExpirationResolver(sharedCache);
        this.responseReader = new SizeLimitedHttpResponseReader(maxResponseSize);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void evict(HttpRequest request) {
        this.cache.evict((Object)this.toKey(request));
    }

    @Override
    public CacheEntry getCacheEntry(HttpRequest request) {
        Cache.ValueWrapper wrapper = this.cache.get((Object)this.toKey(request));
        return wrapper != null ? (CacheEntry)wrapper.get() : null;
    }

    @Override
    public ClientHttpResponse cacheAndReturnResponse(HttpRequest request, ClientHttpResponse response, Date requestSent, Date responseReceived) throws IOException {
        try {
            InMemoryClientHttpResponse fetchedResp = this.responseReader.readResponse(response);
            Date initialDate = this.expirationResolver.resolveInitialDate(fetchedResp, requestSent, responseReceived);
            Date expirationDate = this.expirationResolver.resolveExpirationDate(fetchedResp, initialDate);
            this.cache.put((Object)this.toKey(request), (Object)new CacheEntry(fetchedResp, initialDate, expirationDate));
            return fetchedResp;
        }
        catch (SizeLimitedHttpResponseReader.ResponseSizeLimitExceededException ex) {
            log.info("[{} {}] {}", new Object[]{request.getMethod(), request.getURI(), "actual content length exceeded the limit"});
            return ex.getResponse();
        }
    }

    private String toKey(HttpRequest request) {
        Assert.notNull((Object)request, (String)"request must not be null");
        return this.keyGenerator.createKey(request);
    }

    public ResponseExpirationResolver getExpirationResolver() {
        return this.expirationResolver;
    }

    public void setExpirationResolver(ResponseExpirationResolver expirationResolver) {
        this.expirationResolver = expirationResolver;
    }

    public HttpResponseReader getResponseReader() {
        return this.responseReader;
    }

    public void setResponseReader(HttpResponseReader responseReader) {
        this.responseReader = responseReader;
    }
}

