/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

@NotThreadSafe
public class InMemoryClientHttpResponse
implements ClientHttpResponse,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] body;
    private final HttpStatus statusCode;
    private final HttpHeaders headers;

    public InMemoryClientHttpResponse(byte[] body, HttpStatus statusCode, HttpHeaders headers) {
        Assert.notNull((Object)statusCode, (String)"statusCode must not be null");
        this.body = body != null ? body : new byte[]{};
        this.statusCode = statusCode;
        this.headers = headers != null ? headers : new HttpHeaders();
    }

    public InputStream getBody() {
        return new ByteArrayInputStream(this.body);
    }

    public byte[] getBodyAsByteArray() {
        return this.body;
    }

    public int getRawStatusCode() {
        return this.statusCode.value();
    }

    public String getStatusText() {
        return this.statusCode.getReasonPhrase();
    }

    public void close() {
    }

    public InMemoryClientHttpResponse deepCopy() {
        HttpHeaders headersCopy = new HttpHeaders();
        for (Map.Entry entry : this.headers.entrySet()) {
            headersCopy.put((String)entry.getKey(), new LinkedList((Collection)entry.getValue()));
        }
        return new InMemoryClientHttpResponse((byte[])this.body.clone(), this.statusCode, headersCopy);
    }

    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "InMemoryClientHttpResponse(body=" + this.getBody() + ", statusCode=" + this.getStatusCode() + ", headers=" + this.getHeaders() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InMemoryClientHttpResponse)) {
            return false;
        }
        InMemoryClientHttpResponse other = (InMemoryClientHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        HttpStatus this$statusCode = this.statusCode;
        HttpStatus other$statusCode = other.statusCode;
        if (this$statusCode == null ? other$statusCode != null : !this$statusCode.equals(other$statusCode)) {
            return false;
        }
        HttpHeaders this$headers = this.headers;
        HttpHeaders other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    public boolean canEqual(Object other) {
        return other instanceof InMemoryClientHttpResponse;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + Arrays.hashCode(this.body);
        HttpStatus $statusCode = this.statusCode;
        result = result * 31 + ($statusCode == null ? 0 : $statusCode.hashCode());
        HttpHeaders $headers = this.headers;
        result = result * 31 + ($headers == null ? 0 : $headers.hashCode());
        return result;
    }
}

