/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.spring.http.client.cache.internal;

import cz.jirutka.spring.http.client.cache.internal.CombinedClientHttpResponse;
import cz.jirutka.spring.http.client.cache.internal.HttpResponseReader;
import cz.jirutka.spring.http.client.cache.internal.InMemoryClientHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import net.jcip.annotations.Immutable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

@Immutable
public class SizeLimitedHttpResponseReader
implements HttpResponseReader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final double INITIAL_CAPACITY_FACTOR = 0.3;
    private final int maxBodySize;
    private final int bufferSize;

    public SizeLimitedHttpResponseReader(int maxBodySize) {
        this(maxBodySize, 2048);
    }

    public SizeLimitedHttpResponseReader(int maxBodySize, int bufferSize) {
        Assert.isTrue((maxBodySize > 0 ? 1 : 0) != 0, (String)"bytesLimit must be greater then zero");
        Assert.isTrue((maxBodySize > 0 ? 1 : 0) != 0, (String)"bufferSize must be greater then zero");
        this.maxBodySize = maxBodySize;
        this.bufferSize = bufferSize;
    }

    @Override
    public InMemoryClientHttpResponse readResponse(ClientHttpResponse response) throws ResponseSizeLimitExceededException, IOException {
        Assert.notNull((Object)response, (String)"response must not be null");
        InputStream bodyStream = response.getBody();
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.initialCapacity());
        long bytesTotal = 0L;
        byte[] buffer = new byte[this.bufferSize];
        int bytesRead = -1;
        while ((bytesRead = bodyStream.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            if ((bytesTotal += (long)bytesRead) <= (long)(this.maxBodySize - 1)) continue;
            throw new ResponseSizeLimitExceededException(this.createCombinedResponse(response, out, bodyStream));
        }
        response.close();
        return this.createInMemoryResponse(response, out);
    }

    private int initialCapacity() {
        return new Double((double)this.maxBodySize * 0.3).intValue();
    }

    private CombinedClientHttpResponse createCombinedResponse(ClientHttpResponse originalResponse, ByteArrayOutputStream consumedBody, InputStream originalBody) {
        SequenceInputStream combinedBody = new SequenceInputStream(new ByteArrayInputStream(consumedBody.toByteArray()), originalBody);
        return new CombinedClientHttpResponse(originalResponse, combinedBody);
    }

    private InMemoryClientHttpResponse createInMemoryResponse(ClientHttpResponse originalResponse, ByteArrayOutputStream body) throws IOException {
        HttpStatus status = originalResponse.getStatusCode();
        HttpHeaders headers = originalResponse.getHeaders();
        return new InMemoryClientHttpResponse(body.toByteArray(), status, headers);
    }

    public static class ResponseSizeLimitExceededException
    extends IOException {
        private final ClientHttpResponse response;

        public ResponseSizeLimitExceededException(ClientHttpResponse response) {
            this.response = response;
        }

        public ClientHttpResponse getResponse() {
            return this.response;
        }
    }
}

