/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.AbstractStatusChangeNotifier;
import java.net.URI;
import java.util.HashMap;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import reactor.core.publisher.Mono;

public class DiscordNotifier
extends AbstractStatusChangeNotifier {
    private static final String DEFAULT_MESSAGE = "*#{instance.registration.name}* (#{instance.id}) is *#{event.statusInfo.status}*";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate;
    private Expression message;
    @Nullable
    private URI webhookUrl;
    private boolean tts = false;
    @Nullable
    private String username;
    @Nullable
    private String avatarUrl;

    public DiscordNotifier(InstanceRepository repository, RestTemplate restTemplate) {
        super(repository);
        this.restTemplate = restTemplate;
        this.message = this.parser.parseExpression(DEFAULT_MESSAGE, ParserContext.TEMPLATE_EXPRESSION);
    }

    @Override
    protected Mono<Void> doNotify(InstanceEvent event, Instance instance) {
        if (this.webhookUrl == null) {
            return Mono.error((Throwable)new IllegalStateException("'webhookUrl' must not be null."));
        }
        return Mono.fromRunnable(() -> this.restTemplate.postForEntity(this.webhookUrl, this.createDiscordNotification(event, instance), Void.class));
    }

    protected Object createDiscordNotification(InstanceEvent event, Instance instance) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("content", this.createContent(event, instance));
        body.put("tts", this.tts);
        if (this.avatarUrl != null) {
            body.put("avatar_url", this.avatarUrl);
        }
        if (this.username != null) {
            body.put("username", this.username);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("User-Agent", "RestTemplate");
        return new HttpEntity(body, (MultiValueMap)headers);
    }

    @Nullable
    protected String createContent(InstanceEvent event, Instance instance) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("event", event);
        root.put("instance", instance);
        root.put("lastStatus", this.getLastStatus(event.getInstance()));
        StandardEvaluationContext context = new StandardEvaluationContext(root);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        return (String)this.message.getValue((EvaluationContext)context, String.class);
    }

    @Nullable
    public URI getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(@Nullable URI webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public boolean isTts() {
        return this.tts;
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@Nullable String username) {
        this.username = username;
    }

    @Nullable
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public void setAvatarUrl(@Nullable String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getMessage() {
        return this.message.getExpressionString();
    }

    public void setMessage(String message) {
        this.message = this.parser.parseExpression(message, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

