/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.utils.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class SanitizingMapSerializer
extends StdSerializer<Map<String, String>> {
    private static final long serialVersionUID = 1L;
    private final Pattern[] keysToSanitize;

    public SanitizingMapSerializer(String[] patterns) {
        super(Map.class);
        this.keysToSanitize = SanitizingMapSerializer.createPatterns(patterns);
    }

    private static Pattern[] createPatterns(String ... keys) {
        return (Pattern[])Arrays.stream(keys).map(key -> Pattern.compile(key, 2)).toArray(Pattern[]::new);
    }

    public void serialize(Map<String, String> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            gen.writeStringField(entry.getKey(), this.sanitize(entry.getKey(), entry.getValue()));
        }
        gen.writeEndObject();
    }

    @Nullable
    private String sanitize(String key, @Nullable String value) {
        if (value == null) {
            return null;
        }
        boolean matchesAnyPattern = Arrays.stream(this.keysToSanitize).anyMatch(pattern -> pattern.matcher(key).matches());
        return matchesAnyPattern ? "******" : value;
    }
}

