/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.extensions;

import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class UiExtensions
implements Iterable<UiExtension> {
    public static final UiExtensions EMPTY = new UiExtensions(Collections.emptyList());
    private final List<UiExtension> extensions;

    public UiExtensions(List<UiExtension> extensions) {
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @Override
    public Iterator<UiExtension> iterator() {
        return this.extensions.iterator();
    }

    public List<UiExtension> getCssExtensions() {
        return this.extensions.stream().filter(e -> e.getResourcePath().endsWith(".css")).collect(Collectors.toList());
    }

    public List<UiExtension> getJsExtensions() {
        return this.extensions.stream().filter(e -> e.getResourcePath().endsWith(".js")).collect(Collectors.toList());
    }

    @Generated
    public List<UiExtension> getExtensions() {
        return this.extensions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UiExtensions)) {
            return false;
        }
        UiExtensions other = (UiExtensions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UiExtension> this$extensions = this.getExtensions();
        List<UiExtension> other$extensions = other.getExtensions();
        return !(this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UiExtensions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UiExtension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UiExtensions(extensions=" + this.getExtensions() + ")";
    }
}

