/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web.servlet;

import de.codecentric.boot.admin.server.ui.web.HomepageForwardingFilterConfig;
import de.codecentric.boot.admin.server.ui.web.HomepageForwardingMatcher;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.util.UrlPathHelper;

public class HomepageForwardingFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(HomepageForwardingFilter.class);
    private final String homepage;
    private final HomepageForwardingMatcher<HttpServletRequest> matcher;

    public HomepageForwardingFilter(String homepage, List<String> routes, List<String> excludedRoutes) {
        this.homepage = homepage;
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        this.matcher = new HomepageForwardingMatcher<HttpServletRequest>(routes, excludedRoutes, HttpServletRequest::getMethod, arg_0 -> ((UrlPathHelper)urlPathHelper).getPathWithinApplication(arg_0), r -> MediaType.parseMediaTypes((String)r.getHeader("Accept")));
    }

    public HomepageForwardingFilter(HomepageForwardingFilterConfig filterConfig) {
        this(filterConfig.getHomepage(), filterConfig.getRoutesIncludes(), filterConfig.getRoutesExcludes());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        if (request instanceof HttpServletRequest && this.matcher.test(httpRequest = (HttpServletRequest)request)) {
            log.trace("Forwarding request with URL {} to index", (Object)httpRequest.getRequestURI());
            request.getRequestDispatcher(this.homepage).forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

