/*
 * Decompiled with CFR 0.152.
 */
package de.devsurf.tools.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInToOut(InputStream in, String inputEncoding, OutputStream out, String outputEncoding, int bufferSize, boolean forceClose) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        try {
            int len;
            byte[] buffer = new byte[bufferSize];
            while ((len = bis.read(buffer)) >= 0) {
                String b = new String(buffer, 0, len, inputEncoding);
                bos.write(b.getBytes(outputEncoding));
            }
        }
        finally {
            if (forceClose) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
                try {
                    bos.flush();
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInToOut(InputStream in, OutputStream out, int bufferSize, boolean forceClose) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(in);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        try {
            int len;
            byte[] buffer = new byte[bufferSize];
            while ((len = bis.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
        }
        finally {
            if (forceClose) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
                try {
                    bos.flush();
                    bos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static byte[] append(byte[] array1, byte[] array2) {
        byte[] newArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static byte[] readBytes(InputStream in, int bufferSize, boolean forceClose) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        StreamUtil.copyInToOut(in, baos, bufferSize, forceClose);
        return baos.toByteArray();
    }

    public static boolean compare(InputStream content1, InputStream content2) throws IOException {
        int b2;
        int b1;
        BufferedInputStream i1 = new BufferedInputStream(content1);
        BufferedInputStream i2 = new BufferedInputStream(content2);
        while ((b1 = ((InputStream)i1).read()) == (b2 = ((InputStream)i2).read()) && b1 != -1) {
        }
        ((InputStream)i1).close();
        ((InputStream)i2).close();
        return b1 == -1;
    }
}

