/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.MongodExecutable;
import de.flapdoodle.embedmongo.config.MongodConfig;
import de.flapdoodle.embedmongo.config.MongodProcessOutputConfig;
import de.flapdoodle.embedmongo.distribution.Distribution;
import de.flapdoodle.embedmongo.io.LogWatchStreamProcessor;
import de.flapdoodle.embedmongo.io.Processors;
import de.flapdoodle.embedmongo.io.StreamToLineProcessor;
import de.flapdoodle.embedmongo.runtime.Mongod;
import de.flapdoodle.embedmongo.runtime.Network;
import de.flapdoodle.embedmongo.runtime.ProcessControl;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MongodProcess {
    static final Logger _logger = Logger.getLogger(MongodProcess.class.getName());
    private final MongodConfig _config;
    private final MongodProcessOutputConfig _outputConfig;
    private final MongodExecutable _mongodExecutable;
    private ProcessControl _process;
    private int _mongodProcessId;
    private File _dbDir;
    boolean _stopped = false;
    private Distribution _distribution;

    public MongodProcess(Distribution distribution, MongodConfig config, MongodProcessOutputConfig outputConfig, MongodExecutable mongodExecutable) throws IOException {
        this._config = config;
        this._outputConfig = outputConfig;
        this._mongodExecutable = mongodExecutable;
        this._distribution = distribution;
        try {
            File dbDir;
            if (config.getDatabaseDir() != null) {
                dbDir = Files.createOrCheckDir(config.getDatabaseDir());
            } else {
                this._dbDir = dbDir = Files.createTempDir("embedmongo-db");
            }
            this._process = ProcessControl.fromCommandLine(Mongod.enhanceCommandLinePlattformSpecific(distribution, Mongod.getCommandLine(this._config, this._mongodExecutable.getFile(), dbDir)), true);
            Runtime.getRuntime().addShutdownHook(new JobKiller());
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("waiting for connections on port", "failed", StreamToLineProcessor.wrap(outputConfig.getMongodOutput()));
            Processors.connect(this._process.getReader(), logWatch);
            Processors.connect(this._process.getError(), StreamToLineProcessor.wrap(outputConfig.getMongodError()));
            logWatch.waitForResult(20000L);
            if (!logWatch.isInitWithSuccess()) {
                throw new IOException("Could not start mongod process");
            }
            this._mongodProcessId = Mongod.getMongodProcessId(logWatch.getOutput(), -1);
        }
        catch (IOException iox) {
            this.stop();
            throw iox;
        }
    }

    public synchronized void stop() {
        if (!this._stopped) {
            this._stopped = true;
            _logger.warning("try to stop mongod");
            if (!this.sendStopToMongoInstance()) {
                _logger.warning("could not stop mongod with db command, try next");
                if (!this.sendKillToMongodProcess()) {
                    _logger.warning("could not stop mongod, try next");
                    if (!this.tryKillToMongodProcess()) {
                        _logger.warning("could not stop mongod the second time, try one last thing");
                    }
                }
            }
            this._process.stop();
            if (this._dbDir != null && !Files.forceDelete(this._dbDir)) {
                _logger.warning("Could not delete temp db dir: " + this._dbDir);
            }
        }
    }

    private boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(Network.getLocalHost(), this._config.getPort());
        }
        catch (UnknownHostException e) {
            _logger.log(Level.SEVERE, "sendStop", e);
            return false;
        }
    }

    private boolean sendKillToMongodProcess() {
        if (this._mongodProcessId > 0) {
            return ProcessControl.killProcess(this._distribution.getPlatform(), StreamToLineProcessor.wrap(this._outputConfig.getCommandsOutput()), this._mongodProcessId);
        }
        return false;
    }

    private boolean tryKillToMongodProcess() {
        if (this._mongodProcessId > 0) {
            return ProcessControl.tryKillProcess(this._distribution.getPlatform(), StreamToLineProcessor.wrap(this._outputConfig.getCommandsOutput()), this._mongodProcessId);
        }
        return false;
    }

    class JobKiller
    extends Thread {
        JobKiller() {
        }

        @Override
        public void run() {
            MongodProcess.this.stop();
        }
    }
}

