/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embedmongo.extract;

import de.flapdoodle.embedmongo.Files;
import de.flapdoodle.embedmongo.config.RuntimeConfig;
import de.flapdoodle.embedmongo.extract.IExtractor;
import de.flapdoodle.embedmongo.output.IProgressListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class TgzExtractor
implements IExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(RuntimeConfig runtime, File source, File destination, Pattern file) throws IOException {
        IProgressListener progressListener = runtime.getProgressListener();
        String progressLabel = "Extract " + source;
        progressListener.start(progressLabel);
        FileInputStream fin = new FileInputStream(source);
        BufferedInputStream in = new BufferedInputStream(fin);
        GzipCompressorInputStream gzIn = new GzipCompressorInputStream((InputStream)in);
        TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzIn);
        try {
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                if (!file.matcher(entry.getName()).matches()) continue;
                if (tarIn.canReadEntryData((ArchiveEntry)entry)) {
                    long size = entry.getSize();
                    Files.write((InputStream)tarIn, size, destination);
                    destination.setExecutable(true);
                    progressListener.done(progressLabel);
                }
                break;
            }
        }
        finally {
            tarIn.close();
            gzIn.close();
        }
    }
}

