/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.Edge;
import de.flapdoodle.graph.Loop;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="Loop", generator="Immutables")
public final class ImmutableLoop<V, E>
implements Loop<V, E> {
    private final Set<Edge<V, E>> edges;
    private volatile transient long lazyInitBitmap;
    private static final long VERTEX_SET_LAZY_INIT_BIT = 1L;
    private transient Set<V> vertexSet;

    private ImmutableLoop(Set<Edge<V, E>> edges) {
        this.edges = edges;
    }

    @Override
    public Set<Edge<V, E>> edges() {
        return this.edges;
    }

    @SafeVarargs
    public final ImmutableLoop<V, E> withEdges(Edge<V, E> ... elements) {
        Set<Edge<V, E>> newValue = ImmutableLoop.createUnmodifiableSet(ImmutableLoop.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLoop<V, E>(newValue);
    }

    public final ImmutableLoop<V, E> withEdges(Iterable<? extends Edge<V, E>> elements) {
        if (this.edges == elements) {
            return this;
        }
        Set<Edge<V, E>> newValue = ImmutableLoop.createUnmodifiableSet(ImmutableLoop.createSafeList(elements, true, false));
        return new ImmutableLoop<V, E>(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoop && this.equalTo(0, (ImmutableLoop)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoop<?, ?> another) {
        return this.edges.equals(another.edges);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.edges.hashCode();
        return h;
    }

    public String toString() {
        return "Loop{edges=" + this.edges + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<V> vertexSet() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableLoop immutableLoop = this;
            synchronized (immutableLoop) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.vertexSet = Objects.requireNonNull(Loop.super.vertexSet(), "vertexSet");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.vertexSet;
    }

    public static <V, E> ImmutableLoop<V, E> copyOf(Loop<V, E> instance) {
        if (instance instanceof ImmutableLoop) {
            return (ImmutableLoop)instance;
        }
        return ImmutableLoop.builder().from(instance).build();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="Loop", generator="Immutables")
    public static final class Builder<V, E> {
        private List<Edge<V, E>> edges = new ArrayList<Edge<V, E>>();

        private Builder() {
        }

        public final Builder<V, E> from(Loop<V, E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllEdges(instance.edges());
            return this;
        }

        public final Builder<V, E> addEdges(Edge<V, E> element) {
            this.edges.add(Objects.requireNonNull(element, "edges element"));
            return this;
        }

        @SafeVarargs
        public final Builder<V, E> addEdges(Edge<V, E> ... elements) {
            for (Edge<V, E> element : elements) {
                this.edges.add(Objects.requireNonNull(element, "edges element"));
            }
            return this;
        }

        public final Builder<V, E> edges(Iterable<? extends Edge<V, E>> elements) {
            this.edges.clear();
            return this.addAllEdges(elements);
        }

        public final Builder<V, E> addAllEdges(Iterable<? extends Edge<V, E>> elements) {
            for (Edge<V, E> element : elements) {
                this.edges.add(Objects.requireNonNull(element, "edges element"));
            }
            return this;
        }

        public ImmutableLoop<V, E> build() {
            return new ImmutableLoop(ImmutableLoop.createUnmodifiableSet(this.edges));
        }
    }
}

