package de.flapdoodle.types;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Either.Left}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLeft.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableLeft.of()}.
 */
@Generated(from = "Either.Left", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableLeft<L, R> extends Either.Left<L, R> {
  private final L left;

  private ImmutableLeft(L left) {
    this.left = Objects.requireNonNull(left, "left");
  }

  private ImmutableLeft(ImmutableLeft<L, R> original, L left) {
    this.left = left;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public L left() {
    return left;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Either.Left#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLeft<L, R> withLeft(L value) {
    if (this.left == value) return this;
    L newValue = Objects.requireNonNull(value, "left");
    return new ImmutableLeft<>(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLeft} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLeft<?, ?>
        && equalTo((ImmutableLeft<?, ?>) another);
  }

  private boolean equalTo(ImmutableLeft<?, ?> another) {
    return left.equals(another.left);
  }

  /**
   * Computes a hash code from attributes: {@code left}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + left.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Left} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Left{"
        + "left=" + left
        + "}";
  }

  /**
   * Construct a new immutable {@code Left} instance.
 * @param <L> generic parameter L
 * @param <R> generic parameter R
   * @param left The value for the {@code left} attribute
   * @return An immutable Left instance
   */
  public static <L, R> ImmutableLeft<L, R> of(L left) {
    return new ImmutableLeft<>(left);
  }

  /**
   * Creates an immutable copy of a {@link Either.Left} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable Left instance
   */
  public static <L, R> ImmutableLeft<L, R> copyOf(Either.Left<L, R> instance) {
    if (instance instanceof ImmutableLeft<?, ?>) {
      return (ImmutableLeft<L, R>) instance;
    }
    return ImmutableLeft.<L, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLeft ImmutableLeft}.
   * <pre>
   * ImmutableLeft.&amp;lt;L, R&amp;gt;builder()
   *    .left(L) // required {@link Either.Left#left() left}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @return A new ImmutableLeft builder
   */
  public static <L, R> ImmutableLeft.Builder<L, R> builder() {
    return new ImmutableLeft.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableLeft ImmutableLeft}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Either.Left", generator = "Immutables")
  public static final class Builder<L, R> {
    private static final long INIT_BIT_LEFT = 0x1L;
    private long initBits = 0x1L;

    private L left;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Left} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> from(Either.Left<L, R> instance) {
      Objects.requireNonNull(instance, "instance");
      left(instance.left());
      return this;
    }

    /**
     * Initializes the value for the {@link Either.Left#left() left} attribute.
     * @param left The value for left 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> left(L left) {
      this.left = Objects.requireNonNull(left, "left");
      initBits &= ~INIT_BIT_LEFT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLeft ImmutableLeft}.
     * @return An immutable instance of Left
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLeft<L, R> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableLeft<>(null, left);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LEFT) != 0) attributes.add("left");
      return "Cannot build Left, some of required attributes are not set " + attributes;
    }
  }
}
