/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.types;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    default public <N extends Exception> ThrowingSupplier<T, N> mapCheckedException(Function<Exception, N> exceptionMapper) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw (Exception)exceptionMapper.apply(e);
            }
        };
    }

    default public ThrowingSupplier<T, E> andFinally(Runnable runnable) {
        return () -> {
            try {
                T t = this.get();
                return t;
            }
            finally {
                runnable.run();
            }
        };
    }

    default public Supplier<T> fallbackTo(Function<Exception, T> exceptionToFallback) {
        return () -> {
            try {
                return this.get();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                return exceptionToFallback.apply(e);
            }
        };
    }

    default public Supplier<Optional<T>> onCheckedException(Consumer<Exception> onException) {
        return () -> {
            try {
                return Optional.of(this.get());
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                onException.accept(e);
                return Optional.empty();
            }
        };
    }
}

