package de.flapdoodle.types;

import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Either.Left}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLeft.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableLeft.of()}.
 */
@Generated(from = "Either.Left", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
final class ImmutableLeft<L, R> extends Either.Left<L, R> {
  private final @Nullable L left;

  private ImmutableLeft(@Nullable L left) {
    this.left = left;
  }

  /**
   * @return The value of the {@code left} attribute
   */
  @Override
  public @Nullable L left() {
    return left;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Either.Left#left() left} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for left (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLeft<L, R> withLeft(@Nullable L value) {
    if (this.left == value) return this;
    return new ImmutableLeft<>(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLeft} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLeft<?, ?>
        && equalTo(0, (ImmutableLeft<?, ?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableLeft<?, ?> another) {
    return Objects.equals(left, another.left);
  }

  /**
   * Computes a hash code from attributes: {@code left}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(left);
    return h;
  }

  /**
   * Prints the immutable value {@code Left} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Left{"
        + "left=" + left
        + "}";
  }

  /**
   * Construct a new immutable {@code Left} instance.
 * @param <L> generic parameter L
 * @param <R> generic parameter R
   * @param left The value for the {@code left} attribute
   * @return An immutable Left instance
   */
  public static <L, R> ImmutableLeft<L, R> of(@Nullable L left) {
    return new ImmutableLeft<>(left);
  }

  /**
   * Creates an immutable copy of a {@link Either.Left} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @param instance The instance to copy
   * @return A copied immutable Left instance
   */
  public static <L, R> ImmutableLeft<L, R> copyOf(Either.Left<L, R> instance) {
    if (instance instanceof ImmutableLeft<?, ?>) {
      return (ImmutableLeft<L, R>) instance;
    }
    return ImmutableLeft.<L, R>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLeft ImmutableLeft}.
   * <pre>
   * ImmutableLeft.&amp;lt;L, R&amp;gt;builder()
   *    .left(L | null) // nullable {@link Either.Left#left() left}
   *    .build();
   * </pre>
   * @param <L> generic parameter L
   * @param <R> generic parameter R
   * @return A new ImmutableLeft builder
   */
  public static <L, R> ImmutableLeft.Builder<L, R> builder() {
    return new ImmutableLeft.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableLeft ImmutableLeft}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Either.Left", generator = "Immutables")
  public static final class Builder<L, R> {
    private L left;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Left} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> from(Either.Left<L, R> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable L leftValue = instance.left();
      if (leftValue != null) {
        left(leftValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Either.Left#left() left} attribute.
     * @param left The value for left (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<L, R> left(@Nullable L left) {
      this.left = left;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLeft ImmutableLeft}.
     * @return An immutable instance of Left
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLeft<L, R> build() {
      return new ImmutableLeft<>(left);
    }
  }
}
