/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.net;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.net.ProxyFactory;
import de.flapdoodle.net.ProxySelector;
import de.flapdoodle.net.Proxys;
import de.flapdoodle.types.Optionals;
import de.flapdoodle.types.ThrowingFunction;
import de.flapdoodle.types.ThrowingSupplier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConnections {
    private static final Logger logger = LoggerFactory.getLogger(URLConnections.class);
    public static final String USE_ENV_PROXY_SELECTOR = "de.flapdoodle.net.useEnvProxySelector";
    private static final int BUFFER_LENGTH = 65536;
    private static final boolean useEnvProxySelector = System.getProperty("de.flapdoodle.net.useEnvProxySelector", "false").equals("true");

    public static URLConnection urlConnectionOf(URL url) throws IOException {
        return URLConnections.urlConnectionOf(url, Optional.empty());
    }

    public static URLConnection urlConnectionOf(URL url, Proxy proxy) throws IOException {
        return URLConnections.urlConnectionOf(url, Optional.of(proxy));
    }

    private static URLConnection urlConnectionOf(URL url, Optional<Proxy> providedProxy) throws IOException {
        logger.debug("de.flapdoodle.net.useEnvProxySelector={}", (Object)useEnvProxySelector);
        Optional<Proxy> proxy = providedProxy.isPresent() ? providedProxy : (useEnvProxySelector ? ProxySelector.envVariableProxySelector().select(url).map(ProxyFactory::create) : Optional.empty());
        URLConnection openConnection = Optionals.with(proxy).map(url::openConnection).orElseGet(url::openConnection);
        proxy.ifPresent(it -> {
            if (it instanceof Proxys.UseBasicAuth) {
                Proxys.UseBasicAuth withBasicAuth = (Proxys.UseBasicAuth)((Object)it);
                String authHeader = new String(Base64.getEncoder().encode((withBasicAuth.proxyUser() + ":" + withBasicAuth.proxyPassword()).getBytes()));
                openConnection.setRequestProperty("Proxy-Authorization", "Basic " + authHeader);
                if (url.getProtocol().equals("https")) {
                    throw new IllegalArgumentException("access of a https url over a proxy with proxy authorization is not supported");
                }
            }
        });
        return openConnection;
    }

    public static byte[] downloadIntoByteArray(URLConnection connection) throws IOException {
        return URLConnections.downloadIntoByteArray(connection, (url, bytesCopied, contentLength) -> {});
    }

    public static byte[] downloadIntoByteArray(URLConnection connection, DownloadCopyListener copyListener) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        URLConnections.downloadAndCopy(connection, () -> new BufferedOutputStream(os), copyListener);
        return os.toByteArray();
    }

    public static void downloadIntoFile(URLConnection connection, Path destination, DownloadCopyListener copyListener) throws IOException {
        URLConnections.downloadTo(connection, destination, c -> URLConnections.downloadIntoTempFile(c, copyListener));
    }

    public static Path downloadIntoTempFile(URLConnection connection) throws IOException {
        return URLConnections.downloadIntoTempFile(connection, (url, bytesCopied, contentLength) -> {});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path downloadIntoTempFile(URLConnection connection, DownloadCopyListener copyListener) throws IOException {
        Path tempFile = Files.createTempFile("download", "", new FileAttribute[0]);
        boolean downloadSucceeded = false;
        try {
            URLConnections.downloadAndCopy(connection, () -> new BufferedOutputStream(Files.newOutputStream(tempFile.toFile().toPath(), new OpenOption[0])), copyListener);
            downloadSucceeded = true;
            Path path = tempFile;
            return path;
        }
        finally {
            if (!downloadSucceeded) {
                Files.delete(tempFile);
            }
        }
    }

    protected static <E extends Exception> void downloadTo(URLConnection connection, Path destination, ThrowingFunction<URLConnection, Path, E> urlToTempFile) throws IOException, E {
        Preconditions.checkArgument(!Files.exists(destination, new LinkOption[0]), "destination exists: %s", destination);
        Path tempFile = urlToTempFile.apply(connection);
        URLConnections.move(tempFile, destination);
    }

    protected static void move(Path tempFile, Path destination) throws IOException {
        try {
            Files.move(tempFile, destination, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException ex) {
            Files.move(tempFile, destination, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private static <E extends Exception> void downloadAndCopy(URLConnection connection, ThrowingSupplier<BufferedOutputStream, E> output, DownloadCopyListener copyListener) throws IOException, E {
        long length = connection.getContentLengthLong();
        copyListener.downloaded(connection.getURL(), 0L, length);
        try (BufferedInputStream bis = new BufferedInputStream(connection.getInputStream());
             BufferedOutputStream bos = output.get();){
            byte[] buf = new byte[65536];
            int read = 0;
            long readCount = 0L;
            while ((read = bis.read(buf)) != -1) {
                bos.write(buf, 0, read);
                Preconditions.checkArgument(length == -1L || length >= (readCount += (long)read), "hmm.. readCount bigger than contentLength(more than we want to): %s > %s", readCount, length);
                copyListener.downloaded(connection.getURL(), readCount, length);
            }
            bos.flush();
            Preconditions.checkArgument(length == -1L || length == readCount, "hmm.. readCount smaller than contentLength(partial download?): %s > %s", readCount, length);
        }
    }

    @FunctionalInterface
    public static interface DownloadCopyListener {
        public void downloaded(URL var1, long var2, long var4);
    }
}

