/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.reverse.ImmutableStateID;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface StateID<T> {
    @Value.Parameter
    public String name();

    @Value.Parameter
    public Class<T> type();

    public static <T> StateID<T> of(String name, Class<T> type) {
        return ImmutableStateID.of(name, type);
    }

    public static <T> StateID<T> of(Class<T> type) {
        return StateID.of("", type);
    }

    public static Set<StateID<?>> setOf(StateID<?> ... namedTypes) {
        return Collections.unmodifiableSet(Stream.of(namedTypes).collect(Collectors.toSet()));
    }
}

