/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse;

import de.flapdoodle.graph.ImmutableSubGraph;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.TransitionMapping;
import de.flapdoodle.reverse.TransitionWalker;
import de.flapdoodle.reverse.graph.Vertex;
import de.flapdoodle.reverse.naming.HasLabel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

@Generated(from="TransitionWalker.MappedWrapper", generator="Immutables")
final class ImmutableMappedWrapper<T>
extends TransitionWalker.MappedWrapper<T> {
    private final TransitionMapping<T> transitionMapping;
    private final Set<StateID<?>> missingSources;
    private final DefaultDirectedGraph<Vertex, DefaultEdge> graph;
    private final String transitionLabel;
    private volatile transient long lazyInitBitmap;
    private static final long DESTINATION_LAZY_INIT_BIT = 1L;
    private transient StateID<T> destination;
    private static final long SOURCES_LAZY_INIT_BIT = 2L;
    private transient Set<StateID<?>> sources;
    private static final long SUB_GRAPH_LAZY_INIT_BIT = 4L;
    private transient ImmutableSubGraph<Vertex> subGraph;

    private ImmutableMappedWrapper(TransitionMapping<T> transitionMapping, Set<StateID<?>> missingSources, DefaultDirectedGraph<Vertex, DefaultEdge> graph, String transitionLabel) {
        this.transitionMapping = transitionMapping;
        this.missingSources = missingSources;
        this.graph = graph;
        this.transitionLabel = transitionLabel;
    }

    @Override
    protected TransitionMapping<T> transitionMapping() {
        return this.transitionMapping;
    }

    @Override
    protected Set<StateID<?>> missingSources() {
        return this.missingSources;
    }

    @Override
    protected DefaultDirectedGraph<Vertex, DefaultEdge> graph() {
        return this.graph;
    }

    @Override
    public String transitionLabel() {
        return this.transitionLabel;
    }

    public final ImmutableMappedWrapper<T> withTransitionMapping(TransitionMapping<T> value) {
        if (this.transitionMapping == value) {
            return this;
        }
        TransitionMapping<T> newValue = Objects.requireNonNull(value, "transitionMapping");
        return new ImmutableMappedWrapper<T>(newValue, this.missingSources, this.graph, this.transitionLabel);
    }

    @SafeVarargs
    public final ImmutableMappedWrapper<T> withMissingSources(StateID<?> ... elements) {
        Set<StateID<?>> newValue = ImmutableMappedWrapper.createUnmodifiableSet(ImmutableMappedWrapper.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMappedWrapper<T>(this.transitionMapping, newValue, this.graph, this.transitionLabel);
    }

    public final ImmutableMappedWrapper<T> withMissingSources(Iterable<? extends StateID<?>> elements) {
        if (this.missingSources == elements) {
            return this;
        }
        Set<StateID<?>> newValue = ImmutableMappedWrapper.createUnmodifiableSet(ImmutableMappedWrapper.createSafeList(elements, true, false));
        return new ImmutableMappedWrapper<T>(this.transitionMapping, newValue, this.graph, this.transitionLabel);
    }

    public final ImmutableMappedWrapper<T> withGraph(DefaultDirectedGraph<Vertex, DefaultEdge> value) {
        if (this.graph == value) {
            return this;
        }
        DefaultDirectedGraph<Vertex, DefaultEdge> newValue = Objects.requireNonNull(value, "graph");
        return new ImmutableMappedWrapper<T>(this.transitionMapping, this.missingSources, newValue, this.transitionLabel);
    }

    public final ImmutableMappedWrapper<T> withTransitionLabel(String value) {
        String newValue = Objects.requireNonNull(value, "transitionLabel");
        if (this.transitionLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableMappedWrapper<T>(this.transitionMapping, this.missingSources, this.graph, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMappedWrapper && this.equalTo(0, (ImmutableMappedWrapper)another);
    }

    private boolean equalTo(int synthetic, ImmutableMappedWrapper<?> another) {
        return this.transitionMapping.equals(another.transitionMapping) && this.missingSources.equals(another.missingSources) && this.graph.equals(another.graph) && this.transitionLabel.equals(another.transitionLabel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transitionMapping.hashCode();
        h += (h << 5) + this.missingSources.hashCode();
        h += (h << 5) + this.graph.hashCode();
        h += (h << 5) + this.transitionLabel.hashCode();
        return h;
    }

    public String toString() {
        return "MappedWrapper{transitionMapping=" + this.transitionMapping + ", missingSources=" + this.missingSources + ", graph=" + this.graph + ", transitionLabel=" + this.transitionLabel + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateID<T> destination() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableMappedWrapper immutableMappedWrapper = this;
            synchronized (immutableMappedWrapper) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.destination = Objects.requireNonNull(super.destination(), "destination");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<StateID<?>> sources() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableMappedWrapper immutableMappedWrapper = this;
            synchronized (immutableMappedWrapper) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.sources = Objects.requireNonNull(super.sources(), "sources");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.sources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSubGraph<Vertex> subGraph() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableMappedWrapper immutableMappedWrapper = this;
            synchronized (immutableMappedWrapper) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.subGraph = Objects.requireNonNull(super.subGraph(), "subGraph");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.subGraph;
    }

    public static <T> ImmutableMappedWrapper<T> copyOf(TransitionWalker.MappedWrapper<T> instance) {
        if (instance instanceof ImmutableMappedWrapper) {
            return (ImmutableMappedWrapper)instance;
        }
        return ImmutableMappedWrapper.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="TransitionWalker.MappedWrapper", generator="Immutables")
    public static final class Builder<T> {
        private static final long INIT_BIT_TRANSITION_MAPPING = 1L;
        private static final long INIT_BIT_GRAPH = 2L;
        private static final long INIT_BIT_TRANSITION_LABEL = 4L;
        private long initBits = 7L;
        private TransitionMapping<T> transitionMapping;
        private List<StateID<?>> missingSources = new ArrayList();
        private DefaultDirectedGraph<Vertex, DefaultEdge> graph;
        private String transitionLabel;

        private Builder() {
        }

        public final Builder<T> from(TransitionWalker.MappedWrapper<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder<T> from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasLabel instance;
            long bits = 0L;
            if (object instanceof TransitionWalker.MappedWrapper) {
                instance = (TransitionWalker.MappedWrapper)object;
                this.transitionMapping(((TransitionWalker.MappedWrapper)instance).transitionMapping());
                this.addAllMissingSources(((TransitionWalker.MappedWrapper)instance).missingSources());
                this.graph(((TransitionWalker.MappedWrapper)instance).graph());
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(((TransitionWalker.MappedWrapper)instance).transitionLabel());
                    bits |= 1L;
                }
            }
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 1L) == 0L) {
                    this.transitionLabel(instance.transitionLabel());
                    bits |= 1L;
                }
            }
        }

        public final Builder<T> transitionMapping(TransitionMapping<T> transitionMapping) {
            this.transitionMapping = Objects.requireNonNull(transitionMapping, "transitionMapping");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<T> addMissingSources(StateID<?> element) {
            this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
            return this;
        }

        @SafeVarargs
        public final Builder<T> addMissingSources(StateID<?> ... elements) {
            for (StateID<?> element : elements) {
                this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
            }
            return this;
        }

        public final Builder<T> missingSources(Iterable<? extends StateID<?>> elements) {
            this.missingSources.clear();
            return this.addAllMissingSources(elements);
        }

        public final Builder<T> addAllMissingSources(Iterable<? extends StateID<?>> elements) {
            for (StateID<?> element : elements) {
                this.missingSources.add(Objects.requireNonNull(element, "missingSources element"));
            }
            return this;
        }

        public final Builder<T> graph(DefaultDirectedGraph<Vertex, DefaultEdge> graph) {
            this.graph = Objects.requireNonNull(graph, "graph");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<T> transitionLabel(String transitionLabel) {
            this.transitionLabel = Objects.requireNonNull(transitionLabel, "transitionLabel");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMappedWrapper<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMappedWrapper(this.transitionMapping, ImmutableMappedWrapper.createUnmodifiableSet(this.missingSources), this.graph, this.transitionLabel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transitionMapping");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("graph");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("transitionLabel");
            }
            return "Cannot build MappedWrapper, some of required attributes are not set " + attributes;
        }
    }
}

