/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reverse.types;

import de.flapdoodle.reflection.ClassTypeInfo;
import de.flapdoodle.reflection.ListTypeInfo;
import de.flapdoodle.reflection.TypeInfo;
import de.flapdoodle.reverse.types.HasTypeName;
import de.flapdoodle.types.Pair;

public class TypeNames {
    private TypeNames() {
    }

    public static String typeName(TypeInfo<?> type) {
        if (type instanceof ClassTypeInfo) {
            Class t = ((ClassTypeInfo)type).type();
            return TypeNames.typeName(t);
        }
        if (type instanceof ListTypeInfo) {
            return "List<" + TypeNames.typeName(((ListTypeInfo)type).elements()) + ">";
        }
        if (type instanceof Pair.PairTypeInfo) {
            Pair.PairTypeInfo pair = (Pair.PairTypeInfo)type;
            return "Pair<" + TypeNames.typeName(pair.first()) + "," + TypeNames.typeName(pair.second()) + ">";
        }
        if (type instanceof HasTypeName) {
            return ((HasTypeName)type).typeName();
        }
        return type.toString();
    }

    @Deprecated
    public static String typeName(Class<?> type) {
        String ret = type.getSimpleName();
        if (ret.isEmpty()) {
            ret = type.getTypeName();
        }
        return ret;
    }
}

