/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.os.linux;

import de.flapdoodle.os.Version;
import de.flapdoodle.os.common.HasPecularities;
import de.flapdoodle.os.common.OneOf;
import de.flapdoodle.os.common.Peculiarity;
import de.flapdoodle.os.common.attributes.Attribute;
import de.flapdoodle.os.common.types.OsReleaseFile;
import de.flapdoodle.os.linux.OsReleaseFiles;
import java.util.List;

public enum AlmaVersion implements Version
{
    Alma_8(new Peculiarity[]{OneOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.versionMatches(AlmaVersion.almaReleaseFile(), "8"), OsReleaseFiles.versionMatches(OsReleaseFiles.osReleaseFile(), "8")})}),
    Alma_9(new Peculiarity[]{OneOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.versionMatches(AlmaVersion.almaReleaseFile(), "9"), OsReleaseFiles.versionMatches(OsReleaseFiles.osReleaseFile(), "9")})});

    public static final String RELEASE_FILE_NAME = "/etc/almalinux-release";
    private final List<Peculiarity> peculiarities;

    private AlmaVersion(Peculiarity ... peculiarities) {
        this.peculiarities = HasPecularities.asList((Peculiarity[])peculiarities);
    }

    public List<Peculiarity> pecularities() {
        return this.peculiarities;
    }

    static Peculiarity almaReleaseFileNameMatches(String name) {
        return OneOf.of((Peculiarity[])new Peculiarity[]{OsReleaseFiles.nameMatches(AlmaVersion.almaReleaseFile(), name), OsReleaseFiles.nameMatches(OsReleaseFiles.osReleaseFile(), name)});
    }

    private static Attribute<OsReleaseFile> almaReleaseFile() {
        return OsReleaseFiles.releaseFile(RELEASE_FILE_NAME);
    }
}

