/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.api;

import java.math.BigInteger;
import org.osm.schema.Osm;
import org.osm.schema.OsmNode;
import org.osm.schema.OsmRelation;
import org.osm.schema.OsmWay;
import org.osmtools.api.ChangesetOperations;
import org.osmtools.api.OsmApiBinding;
import org.osmtools.api.OsmSchemaService;
import org.osmtools.oauth.OauthCredentials;

public class ChangesetTemplate
extends OsmApiBinding
implements ChangesetOperations {
    private OsmSchemaService osmSchemaService;
    private long changesetId;
    private long created = System.currentTimeMillis();

    public ChangesetTemplate(OsmSchemaService osmSchemaService, String osmApiBaseUrl, Osm osmWithComment, OauthCredentials oauthCredentials) {
        super(osmApiBaseUrl, oauthCredentials);
        this.osmSchemaService = osmSchemaService;
        this.openChangeset(osmWithComment);
    }

    private void openChangeset(Osm osmWithComment) {
        String url = this.osmApiBaseUrl + "/api/0.6/changeset/create";
        this.changesetId = this.putForId(url, osmWithComment);
    }

    @Override
    public long getChangesetId() {
        return this.changesetId;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public void closeChangeset() {
        String url = this.osmApiBaseUrl + "/api/0.6/changeset/" + this.changesetId + "/close";
        this.getRestTemplate().put(url, null, new Object[0]);
    }

    @Override
    public long putWay(OsmWay osmWay) {
        Osm osm = this.osmSchemaService.createOsmNode();
        osmWay.setChangeset(BigInteger.valueOf(this.changesetId));
        osm.getWay().add(osmWay);
        String url = this.osmApiBaseUrl + "/api/0.6/way/" + osmWay.getId().longValue();
        return this.putForId(url, osm);
    }

    @Override
    public long putNode(OsmNode osmNode) {
        Osm osm = this.osmSchemaService.createOsmNode();
        osmNode.setChangeset(BigInteger.valueOf(this.changesetId));
        String url = this.osmApiBaseUrl + "/api/0.6/node/" + osmNode.getId().longValue();
        osm.getNode().add(osmNode);
        return this.putForId(url, osm);
    }

    @Override
    public long putRelation(OsmRelation relation) {
        String url = this.osmApiBaseUrl + "/api/0.6/relation/" + relation.getId().longValue();
        Osm osm = this.osmSchemaService.createOsmNode();
        relation.setChangeset(BigInteger.valueOf(this.changesetId));
        osm.getRelation().add(relation);
        return this.putForId(url, osm);
    }

    @Override
    public long putNewWay(OsmWay osmWay) {
        String url = this.osmApiBaseUrl + "/api/0.6/way/create";
        Osm osm = this.osmSchemaService.createOsmNode();
        osmWay.setChangeset(BigInteger.valueOf(this.changesetId));
        osm.getWay().add(osmWay);
        return this.putForId(url, osm);
    }

    @Override
    public long putNewNode(OsmNode osmNode) {
        String url = this.osmApiBaseUrl + "/api/0.6/node/create";
        Osm osm = this.osmSchemaService.createOsmNode();
        osmNode.setChangeset(BigInteger.valueOf(this.changesetId));
        osm.getNode().add(osmNode);
        return this.putForId(url, osm);
    }

    @Override
    public long putNewRelation(OsmRelation osmRelation) {
        String url = this.osmApiBaseUrl + "/api/0.6/relation/create";
        Osm osm = this.osmSchemaService.createOsmNode();
        osmRelation.setChangeset(BigInteger.valueOf(this.changesetId));
        osm.getRelation().add(osmRelation);
        return this.putForId(url, osm);
    }

    @Override
    public void deleteNode(long nodeId) {
        String url = this.osmApiBaseUrl + "/api/0.6/node/" + nodeId;
        this.deleteForId(url);
    }

    @Override
    public void deleteRelation(long relationId) {
        String url = this.osmApiBaseUrl + "/api/0.6/relation/" + relationId;
        this.deleteForId(url);
    }

    @Override
    public void deleteWay(long wayId) {
        String url = this.osmApiBaseUrl + "/api/0.6/way/" + wayId;
        this.deleteForId(url);
    }
}

