/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.osmtools.api.LonLat;
import org.osmtools.api.Section;
import org.springframework.stereotype.Service;

@Service
public class GeoJsonExport {
    public void export(Iterable<Section> container, OutputStream os) {
        StringBuilder json = new StringBuilder();
        json.append("{\"type\":\"FeatureCollection\",\"features\":[");
        Iterator<Section> it = container.iterator();
        while (it.hasNext()) {
            Section dataContainer = it.next();
            json.append("{\"type\":\"Feature\",\"geometry\":\n");
            json.append("{\"type\":\"LineString\",");
            json.append("\"properties\":{\"name\":\"").append(dataContainer.getName()).append("\"},\n");
            json.append("\"coordinates\":[");
            Iterator<Iterable<? extends LonLat>> itC = dataContainer.getCoordinateLists().iterator();
            while (itC.hasNext()) {
                Iterable<? extends LonLat> coordinates = itC.next();
                this.addTrackpoints(json, coordinates);
                if (!itC.hasNext()) continue;
                json.append(",");
            }
            json.append("]}}");
            if (!it.hasNext()) continue;
            json.append(",\n");
        }
        json.append("]}");
        try {
            os.write(json.toString().getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addTrackpoints(StringBuilder sb, Iterable<? extends LonLat> coordinates) {
        Iterator<? extends LonLat> it = coordinates.iterator();
        while (it.hasNext()) {
            LonLat point = it.next();
            sb.append("[").append(point.getLon()).append(",").append(point.getLat()).append("]");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
    }
}

