/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.api;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.osm.schema.Osm;
import org.springframework.stereotype.Service;

@Service
public class SchemaService {
    public Unmarshaller createOsmUnmarshaller() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Osm.class}).createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Marshaller createOsmMarshaller() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{Osm.class}).createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Osm fromStream(InputStream inputStream) {
        try {
            JAXBElement jaxbElement = this.createOsmUnmarshaller().unmarshal((Source)new StreamSource(inputStream), Osm.class);
            return (Osm)jaxbElement.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

