/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.oauth;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.osmtools.api.OsmOperations;
import org.osmtools.api.UserOperations;
import org.osmtools.oauth.OauthService;
import org.osmtools.oauth.OauthTokens;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class OauthRequestController {
    @Autowired
    private OauthService oauthService;
    @Autowired
    private OsmOperations osmOperations;

    @RequestMapping(value={"/oauthRequest"})
    public void oauthRequest(HttpServletResponse response) throws IOException {
        String url = this.oauthService.getRequestTokenUrl(response);
        response.sendRedirect(url);
    }

    @RequestMapping(value={"/oauthResponse"})
    public String oauthResponse(@RequestParam(value="oauth_token", defaultValue="") String oAuthToken, @RequestParam(value="oauth_verifier", defaultValue="") String oAuthVerifier, RedirectAttributes attributes) {
        OauthTokens oauthTokens = this.oauthService.retrieveAccessToken(oAuthVerifier);
        UserOperations userOperations = this.osmOperations.userOperations(oauthTokens);
        try {
            attributes.addFlashAttribute("osmUser", (Object)userOperations.getForUser());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        attributes.addFlashAttribute("oauthTokens", (Object)oauthTokens);
        return "redirect:index";
    }
}

