/*
 * Decompiled with CFR 0.152.
 */
package org.osmtools.overpass;

import org.osm.schema.Osm;
import org.osmtools.api.BoundingBox;
import org.osmtools.overpass.OverpassOperations;
import org.springframework.web.client.RestOperations;

public class OverpassTemplate
implements OverpassOperations {
    private RestOperations restOperations;

    public OverpassTemplate(RestOperations restOperations) {
        this.restOperations = restOperations;
    }

    public Osm getBBox(BoundingBox boundingBox) {
        String data = "(way[highway=track](" + boundingBox.getSouth() + "," + boundingBox.getWest() + "," + boundingBox.getNorth() + "," + boundingBox.getEast() + ");node(w)->.x;);out meta;";
        return (Osm)this.restOperations.getForObject("http://overpass-api.de/api/interpreter?data={data}", Osm.class, new Object[]{data});
    }

    public Osm getRaw(String query) {
        return (Osm)this.restOperations.getForObject("http://overpass-api.de/api/interpreter?data={data}", Osm.class, new Object[]{query});
    }

    public Osm getBuildings(BoundingBox boundingBox) {
        String data = "(way[building=yes](" + boundingBox.getSouth() + "," + boundingBox.getWest() + "," + boundingBox.getNorth() + "," + boundingBox.getEast() + ");node(w)->.x;);out meta;";
        System.out.println("Data: " + data);
        return (Osm)this.restOperations.getForObject("http://overpass-api.de/api/interpreter?data={data}", Osm.class, new Object[]{data});
    }
}

