/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.ModuleDependencyVerifier;
import de.hilling.maven.release.NoChangesAction;
import de.hilling.maven.release.ReleasableModule;
import de.hilling.maven.release.TreeWalkingDiffDetector;
import de.hilling.maven.release.exceptions.UnresolvedSnapshotDependencyException;
import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.repository.LocalGitRepo;
import de.hilling.maven.release.versioning.ImmutableQualifiedArtifact;
import de.hilling.maven.release.versioning.ReleaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;

public class Reactor {
    private final List<ReleasableModule> modulesInBuildOrder;
    private final Map<ImmutableQualifiedArtifact, ReleasableModule> artifactModuleMap = new HashMap<ImmutableQualifiedArtifact, ReleasableModule>();

    public Reactor(List<ReleasableModule> modulesInBuildOrder) {
        this.modulesInBuildOrder = modulesInBuildOrder;
        modulesInBuildOrder.forEach(m -> {
            ImmutableQualifiedArtifact key = ImmutableQualifiedArtifact.builder().artifactId(m.getProject().getArtifactId()).groupId(m.getProject().getGroupId()).build();
            this.artifactModuleMap.put(key, (ReleasableModule)m);
        });
    }

    public List<ReleasableModule> getModulesInBuildOrder() {
        return this.modulesInBuildOrder;
    }

    public static Reactor fromProjects(Log log, LocalGitRepo gitRepo, MavenProject rootProject, List<MavenProject> projects, List<String> modulesToForceRelease, NoChangesAction actionWhenNoChangesDetected, boolean bugfixRelease, ReleaseInfo previousRelease) throws ValidationException, GitAPIException, MojoExecutionException {
        if (previousRelease.isEmpty()) {
            log.warn((CharSequence)"no info file for previous releases found, assuming initial release");
        }
        TreeWalkingDiffDetector detector = new TreeWalkingDiffDetector(gitRepo.git.getRepository(), log);
        ArrayList<ReleasableModule> modules = new ArrayList<ReleasableModule>();
        for (MavenProject project : projects) {
            modules.add(new ModuleDependencyVerifier(project, rootProject, gitRepo, previousRelease, modulesToForceRelease, modules, bugfixRelease, log).releaseInfo());
        }
        if (!Reactor.atLeastOneBeingReleased(modules)) {
            switch (actionWhenNoChangesDetected) {
                case ReleaseNone: {
                    log.warn((CharSequence)"No changes have been detected in any modules so will not perform release");
                    return null;
                }
                case FailBuild: {
                    throw new MojoExecutionException("No module changes have been detected");
                }
            }
            log.warn((CharSequence)"No changes have been detected in any modules so will re-release them all");
            modules.clear();
            for (MavenProject project : projects) {
                modules.add(new ModuleDependencyVerifier(project, rootProject, gitRepo, previousRelease, modulesToForceRelease, modules, bugfixRelease, log).rereleaseModule());
            }
        }
        return new Reactor(modules);
    }

    private static boolean atLeastOneBeingReleased(List<ReleasableModule> modules) {
        for (ReleasableModule module : modules) {
            if (!module.isToBeReleased()) continue;
            return true;
        }
        return false;
    }

    public ReleasableModule find(String groupId, String artifactId) throws UnresolvedSnapshotDependencyException {
        ImmutableQualifiedArtifact artifact = ImmutableQualifiedArtifact.builder().groupId(groupId).artifactId(artifactId).build();
        if (this.artifactModuleMap.containsKey(artifact)) {
            return this.artifactModuleMap.get(artifact);
        }
        throw new UnresolvedSnapshotDependencyException(groupId, artifactId);
    }
}

