/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import de.hilling.maven.release.AnnotatedTag;
import de.hilling.maven.release.BaseMojo;
import de.hilling.maven.release.PomUpdater;
import de.hilling.maven.release.Reactor;
import de.hilling.maven.release.ReleasableModule;
import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.releaseinfo.ReleaseInfoStorage;
import de.hilling.maven.release.repository.LocalGitRepo;
import de.hilling.maven.release.utils.ReleaseFileUtils;
import de.hilling.maven.release.versioning.ImmutableReleaseInfo;
import de.hilling.maven.release.versioning.ReleaseDateSingleton;
import de.hilling.maven.release.versioning.ReleaseInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.jgit.api.errors.GitAPIException;

@Mojo(name="prepare", requiresDirectInvocation=true, aggregator=true)
public class ReleaseMojo
extends BaseMojo {
    @Override
    public void executeConcreteMojo(Scm scm, Scm originalScm, LocalGitRepo repo) throws MojoExecutionException, MojoFailureException, GitAPIException {
        repo.errorIfNotClean();
        ReleaseInfoStorage infoStorage = new ReleaseInfoStorage(this.project.getBasedir(), repo.git);
        ReleaseInfo previousRelease = infoStorage.load();
        this.getLog().info((CharSequence)("previous release: " + previousRelease));
        Reactor reactor = Reactor.fromProjects(this.getLog(), repo, this.project, this.projects, this.modulesToForceRelease, this.noChangesAction, this.bugfixRelease, previousRelease);
        if (reactor == null) {
            return;
        }
        List<ReleasableModule> releasableModules = reactor.getModulesInBuildOrder();
        ImmutableReleaseInfo.Builder releaseBuilder = ImmutableReleaseInfo.builder().tagName(ReleaseDateSingleton.getInstance().tagName());
        ArrayList<String> modulesToRelease = new ArrayList<String>();
        for (ReleasableModule releasableModule : releasableModules) {
            releaseBuilder.addModules(releasableModule.getImmutableModule());
            if (!releasableModule.isToBeReleased()) continue;
            modulesToRelease.add(releasableModule.getRelativePathToModule());
        }
        ImmutableReleaseInfo currentRelease = releaseBuilder.build();
        infoStorage.store(currentRelease);
        this.getLog().info((CharSequence)("current release: " + currentRelease));
        this.saveModulesToBuild(reactor);
        this.saveFilesToRevert(repo, reactor);
        this.tagRepo(repo, currentRelease);
    }

    private static List<String> updatePomsAndReturnChangedFiles(Log log, LocalGitRepo repo, Reactor reactor) throws MojoExecutionException, ValidationException {
        PomUpdater pomUpdater = new PomUpdater(log, reactor);
        PomUpdater.UpdateResult result = pomUpdater.updateVersion();
        if (!result.success()) {
            log.info((CharSequence)"Going to revert changes because there was an error.");
            repo.revertChanges(log, result.alteredPoms);
            if (result.unexpectedException != null) {
                throw new ValidationException("Unexpected exception while setting the release versions in the pom", result.unexpectedException);
            }
            String summary = "Cannot release with references to snapshot dependencies";
            ArrayList<String> messages = new ArrayList<String>();
            messages.add(summary);
            messages.add("The following dependency errors were found:");
            for (String dependencyError : result.dependencyErrors) {
                messages.add(" * " + dependencyError);
            }
            throw new ValidationException(summary, messages);
        }
        return result.alteredPoms.stream().map(ReleaseFileUtils::canonicalName).collect(Collectors.toList());
    }

    private void saveFilesToRevert(LocalGitRepo repo, Reactor reactor) throws MojoExecutionException {
        List<String> changedFiles = ReleaseMojo.updatePomsAndReturnChangedFiles(this.getLog(), repo, reactor);
        changedFiles.add("modules-to-build.txt");
        changedFiles.add("files-to-revert.txt");
        ReleaseFileUtils.write("files-to-revert.txt", changedFiles.stream().collect(Collectors.joining("\n")));
    }

    private void saveModulesToBuild(Reactor reactor) {
        String changedModules = reactor.getModulesInBuildOrder().stream().filter(ReleasableModule::isToBeReleased).map(ReleasableModule::getRelativePathToModule).collect(Collectors.joining(","));
        ReleaseFileUtils.write("modules-to-build.txt", changedModules);
    }

    private void tagRepo(LocalGitRepo repo, ImmutableReleaseInfo releaseInfo) throws GitAPIException {
        Optional<String> optionalTag = releaseInfo.getTagName();
        if (!optionalTag.isPresent()) {
            throw new ValidationException("internal error: no tag found on release info " + releaseInfo);
        }
        AnnotatedTag tag = new AnnotatedTag(optionalTag.get(), releaseInfo);
        this.getLog().info((CharSequence)("About to tag repository with " + releaseInfo.toString()));
        repo.tagRepo(tag);
    }
}

