/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class TreeWalkingDiffDetector {
    private final Repository repo;
    private final Log log;

    public TreeWalkingDiffDetector(Repository repo, Log log) {
        this.repo = repo;
        this.log = log;
    }

    private static void stopWalkingWhenTheTagsAreHit(Ref tagReference, RevWalk walk) throws IOException {
        ObjectId commitId = tagReference.getTarget().getObjectId();
        RevCommit revCommit = walk.parseCommit((AnyObjectId)commitId);
        walk.markUninteresting(revCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChangedSince(String moduleForChangeDetection, List<String> childModules, Ref tagReference) throws IOException {
        RevWalk walk = new RevWalk(this.repo);
        try {
            walk.setRetainBody(false);
            walk.markStart(walk.parseCommit((AnyObjectId)this.repo.getRef("HEAD").getObjectId()));
            this.filterOutOtherModulesChanges(moduleForChangeDetection, childModules, walk);
            TreeWalkingDiffDetector.stopWalkingWhenTheTagsAreHit(tagReference, walk);
            boolean changed = false;
            Iterator iterator = walk.iterator();
            while (iterator.hasNext()) {
                changed = true;
                this.log.debug((CharSequence)("change detected: " + iterator.next()));
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            walk.dispose();
        }
    }

    private void filterOutOtherModulesChanges(String modulePath, List<String> childModules, RevWalk walk) {
        boolean isRootModule = ".".equals(modulePath);
        boolean isMultiModuleProject = !isRootModule || !childModules.isEmpty();
        ArrayList<Object> treeFilters = new ArrayList<Object>();
        treeFilters.add(TreeFilter.ANY_DIFF);
        if (isMultiModuleProject) {
            if (!isRootModule) {
                treeFilters.add(PathFilter.create((String)modulePath));
            }
            for (String childModule : childModules) {
                String path = isRootModule ? childModule : modulePath + "/" + childModule;
                treeFilters.add(PathFilter.create((String)path).negate());
            }
        }
        TreeFilter treeFilter = treeFilters.size() == 1 ? (TreeFilter)treeFilters.get(0) : AndTreeFilter.create(treeFilters);
        TreeFilter releaseInfoFilter = new TreeFilter(){

            public boolean include(TreeWalk walker) throws IOException {
                String nameString = walker.getPathString();
                return !nameString.endsWith(".release-info.json");
            }

            public boolean shouldBeRecursive() {
                return true;
            }

            public TreeFilter clone() {
                return this;
            }
        };
        walk.setTreeFilter(AndTreeFilter.create((TreeFilter)releaseInfoFilter, (TreeFilter)treeFilter));
    }
}

