/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.releaseinfo;

import com.google.gson.Gson;
import de.hilling.maven.release.versioning.GsonFactory;
import de.hilling.maven.release.versioning.ImmutableReleaseInfo;
import de.hilling.maven.release.versioning.ReleaseInfo;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;

public class ReleaseInfoStorage {
    public static final String RELEASE_INFO_FILE = ".release-info.json";
    private final Git git;
    private File baseDir;

    public ReleaseInfoStorage(File basedir, Git git) {
        this.baseDir = basedir;
        this.git = git;
    }

    public ReleaseInfo load() throws MojoExecutionException {
        ReleaseInfo previousRelease;
        File releaseInfoFile = new File(this.baseDir, RELEASE_INFO_FILE);
        if (releaseInfoFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)releaseInfoFile, (Charset)StandardCharsets.UTF_8);
                previousRelease = (ReleaseInfo)new GsonFactory().createGson().fromJson(json, ImmutableReleaseInfo.class);
            }
            catch (IOException e) {
                throw new MojoExecutionException("unable to read release info file " + releaseInfoFile.getAbsolutePath(), (Exception)e);
            }
        } else {
            previousRelease = ImmutableReleaseInfo.builder().build();
        }
        return previousRelease;
    }

    public void store(ImmutableReleaseInfo releaseInfo) {
        File releaseInfoFile = new File(this.baseDir, RELEASE_INFO_FILE);
        try {
            Gson gson = new GsonFactory().createGson();
            FileUtils.write((File)releaseInfoFile, (CharSequence)gson.toJson((Object)releaseInfo), (Charset)StandardCharsets.UTF_8);
            this.git.add().addFilepattern(RELEASE_INFO_FILE).call();
            this.git.commit().setMessage("updating release versions").call();
        }
        catch (IOException | GitAPIException e) {
            throw new RuntimeException("unable to store and commit release info", e);
        }
    }
}

