/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.repository;

import de.hilling.maven.release.AnnotatedTag;
import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.utils.ReleaseFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;

public class LocalGitRepo {
    public final Git git;
    private final String remoteUrl;
    private final Log log;
    private boolean hasReverted = false;
    private Collection<Ref> remoteTags;

    LocalGitRepo(Git git, String remoteUrl, Log log) {
        this.git = git;
        this.remoteUrl = remoteUrl;
        this.log = log;
    }

    public static LocalGitRepo fromCurrentDir(String remoteUrl, Log log) throws ValidationException {
        Git git;
        File gitDir = new File(".");
        try {
            git = Git.open((File)gitDir);
        }
        catch (RepositoryNotFoundException rnfe) {
            String summary;
            String fullPathOfCurrentDir = ReleaseFileUtils.pathOf(gitDir);
            File gitRoot = LocalGitRepo.getGitRootIfItExistsInOneOfTheParentDirectories(new File(fullPathOfCurrentDir));
            ArrayList<String> messages = new ArrayList<String>();
            if (gitRoot == null) {
                summary = "Releases can only be performed from Git repositories.";
                messages.add(summary);
                messages.add(fullPathOfCurrentDir + " is not a Git repository.");
            } else {
                summary = "The release plugin can only be run from the root folder of your Git repository";
                messages.add(summary);
                messages.add(fullPathOfCurrentDir + " is not the root of a Gir repository");
                messages.add("Try running the release plugin from " + ReleaseFileUtils.pathOf(gitRoot));
            }
            throw new ValidationException(summary, messages);
        }
        catch (Exception e) {
            throw new ValidationException("Could not open git repository. Is " + ReleaseFileUtils.pathOf(gitDir) + " a git repository?", Arrays.asList("Exception returned when accessing the git repo:", e.toString()));
        }
        return new LocalGitRepo(git, remoteUrl, log);
    }

    private static File getGitRootIfItExistsInOneOfTheParentDirectories(File candidateDir) {
        while (candidateDir != null && !candidateDir.getName().equals("target")) {
            if (new File(candidateDir, ".git").isDirectory()) {
                return candidateDir;
            }
            candidateDir = candidateDir.getParentFile();
        }
        return null;
    }

    public void errorIfNotClean() throws ValidationException {
        Status status = this.currentStatus();
        boolean isClean = status.isClean();
        if (!isClean) {
            Set untracked;
            String summary = "Cannot release with uncommitted changes. Please check the following files:";
            ArrayList<String> message = new ArrayList<String>();
            message.add(summary);
            Set uncommittedChanges = status.getUncommittedChanges();
            if (uncommittedChanges.size() > 0) {
                message.add("Uncommitted:");
                for (String path : uncommittedChanges) {
                    message.add(" * " + path);
                }
            }
            if ((untracked = status.getUntracked()).size() > 0) {
                message.add("Untracked:");
                for (String path : untracked) {
                    message.add(" * " + path);
                }
            }
            message.add("Please commit or revert these changes before releasing.");
            throw new ValidationException(summary, message);
        }
    }

    private Status currentStatus() throws ValidationException {
        try {
            return this.git.status().call();
        }
        catch (GitAPIException e) {
            throw new ValidationException("Error while checking if the Git repo is clean", e);
        }
    }

    public boolean revertChanges(Log log, List<File> changedFiles) throws MojoExecutionException {
        if (this.hasReverted) {
            return true;
        }
        boolean hasErrors = false;
        File workTree = this.workingDir();
        for (File changedFile : changedFiles) {
            try {
                String pathRelativeToWorkingTree = Repository.stripWorkDir((File)workTree, (File)changedFile);
                if (this.git.status().addPath(pathRelativeToWorkingTree).call().getUntracked().isEmpty()) {
                    this.git.checkout().addPath(pathRelativeToWorkingTree).call();
                    continue;
                }
                FileUtils.forceDelete((File)changedFile);
            }
            catch (Exception e) {
                hasErrors = true;
                log.error((CharSequence)("Unable to revert changes to " + changedFile + " - you may need to manually revert this file. Error was: " + e.getMessage()));
            }
        }
        this.hasReverted = true;
        return !hasErrors;
    }

    private File workingDir() throws MojoExecutionException {
        try {
            return this.git.getRepository().getWorkTree().getCanonicalFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not locate the working directory of the Git repo", (Exception)e);
        }
    }

    public void tagRepo(AnnotatedTag tag) throws GitAPIException {
        tag.saveAtHEAD(this.git);
    }

    public void pushAll() throws GitAPIException {
        block3: {
            PushCommand pushAll = this.git.push().setPushAll().setPushTags();
            FetchCommand fetchCommand = this.git.fetch();
            fetchCommand.setRefSpecs(new RefSpec[]{new RefSpec("+refs/heads/*:refs/remotes/origin/*"), new RefSpec("+refs/tags/*:refs/tags/*"), new RefSpec("+refs/notes/*:refs/notes/*")});
            if (this.remoteUrl != null) {
                pushAll.setRemote(this.remoteUrl);
                fetchCommand.setRemote(this.remoteUrl);
            }
            pushAll.call().iterator().forEachRemaining(this::logResult);
            try {
                fetchCommand.call();
            }
            catch (GitAPIException gae) {
                if (gae.getMessage().contains("Nothing to fetch")) break block3;
                throw gae;
            }
        }
    }

    private void logResult(PushResult m) {
        this.log.debug((CharSequence)("push: " + m.getRemoteUpdates().stream().map(RemoteRefUpdate::toString).collect(Collectors.joining(","))));
    }

    public Optional<Ref> getRemoteTag(String tagName) throws GitAPIException {
        ArrayList results = new ArrayList();
        Collection<Ref> remoteTags = this.allRemoteTags();
        for (Ref remoteTag : remoteTags) {
            if (!remoteTag.getName().equals("refs/tags/" + tagName)) continue;
            return Optional.of(remoteTag);
        }
        return Optional.empty();
    }

    private Collection<Ref> allRemoteTags() throws GitAPIException {
        if (this.remoteTags == null) {
            LsRemoteCommand lsRemoteCommand = this.git.lsRemote().setTags(true).setHeads(false);
            if (this.remoteUrl != null) {
                lsRemoteCommand.setRemote(this.remoteUrl);
            }
            this.remoteTags = lsRemoteCommand.call();
        }
        return this.remoteTags;
    }
}

