/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.utils;

import de.hilling.maven.release.exceptions.ReleaseException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class ReleaseFileUtils {
    public static String pathOf(File file) {
        String path;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException e1) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public static void write(String fileName, String string) {
        try {
            File file = new File(fileName);
            if (file.exists()) {
                throw new ReleaseException("file already exists: " + fileName);
            }
            if (string.endsWith("\n")) {
                FileUtils.write((File)file, (CharSequence)string, (Charset)StandardCharsets.UTF_8);
            } else {
                FileUtils.write((File)file, (CharSequence)(string + "\n"), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new ReleaseException("unable to write " + fileName, e);
        }
    }

    public static List<String> read(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new ReleaseException("file does not exists: " + fileName);
        }
        try {
            return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ReleaseException("unable to read " + fileName, e);
        }
    }

    public static String canonicalName(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new ReleaseException("unable to get canonical path " + file, e);
        }
    }
}

