/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.FixVersion;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableFixVersion
extends FixVersion {
    private final long majorVersion;
    private final long minorVersion;
    @Nullable
    private final Long bugfixVersion;

    private ImmutableFixVersion(long majorVersion, long minorVersion, @Nullable Long bugfixVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.bugfixVersion = bugfixVersion;
    }

    @Override
    public long getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public long getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public Optional<Long> getBugfixVersion() {
        return Optional.ofNullable(this.bugfixVersion);
    }

    public final ImmutableFixVersion withMajorVersion(long value) {
        if (this.majorVersion == value) {
            return this;
        }
        return new ImmutableFixVersion(value, this.minorVersion, this.bugfixVersion);
    }

    public final ImmutableFixVersion withMinorVersion(long value) {
        if (this.minorVersion == value) {
            return this;
        }
        return new ImmutableFixVersion(this.majorVersion, value, this.bugfixVersion);
    }

    public final ImmutableFixVersion withBugfixVersion(long value) {
        Long newValue = value;
        if (Objects.equals(this.bugfixVersion, newValue)) {
            return this;
        }
        return new ImmutableFixVersion(this.majorVersion, this.minorVersion, newValue);
    }

    public final ImmutableFixVersion withBugfixVersion(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.bugfixVersion, value)) {
            return this;
        }
        return new ImmutableFixVersion(this.majorVersion, this.minorVersion, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFixVersion && this.equalTo((ImmutableFixVersion)another);
    }

    private boolean equalTo(ImmutableFixVersion another) {
        return this.majorVersion == another.majorVersion && this.minorVersion == another.minorVersion && Objects.equals(this.bugfixVersion, another.bugfixVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.majorVersion);
        h += (h << 5) + Long.hashCode(this.minorVersion);
        h += (h << 5) + Objects.hashCode(this.bugfixVersion);
        return h;
    }

    public static ImmutableFixVersion copyOf(FixVersion instance) {
        if (instance instanceof ImmutableFixVersion) {
            return (ImmutableFixVersion)instance;
        }
        return ImmutableFixVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAJOR_VERSION = 1L;
        private static final long INIT_BIT_MINOR_VERSION = 2L;
        private long initBits = 3L;
        private long majorVersion;
        private long minorVersion;
        @Nullable
        private Long bugfixVersion;

        private Builder() {
        }

        public final Builder from(FixVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.majorVersion(instance.getMajorVersion());
            this.minorVersion(instance.getMinorVersion());
            Optional<Long> bugfixVersionOptional = instance.getBugfixVersion();
            if (bugfixVersionOptional.isPresent()) {
                this.bugfixVersion(bugfixVersionOptional);
            }
            return this;
        }

        public final Builder majorVersion(long majorVersion) {
            this.majorVersion = majorVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minorVersion(long minorVersion) {
            this.minorVersion = minorVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bugfixVersion(long bugfixVersion) {
            this.bugfixVersion = bugfixVersion;
            return this;
        }

        public final Builder bugfixVersion(Optional<Long> bugfixVersion) {
            this.bugfixVersion = bugfixVersion.orElse(null);
            return this;
        }

        public ImmutableFixVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFixVersion(this.majorVersion, this.minorVersion, this.bugfixVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("majorVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("minorVersion");
            }
            return "Cannot build FixVersion, some of required attributes are not set " + attributes;
        }
    }
}

