/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.versioning.FixVersion;
import de.hilling.maven.release.versioning.ImmutableFixVersion;
import de.hilling.maven.release.versioning.ImmutableModuleVersion;
import de.hilling.maven.release.versioning.ImmutableQualifiedArtifact;
import de.hilling.maven.release.versioning.ModuleVersion;
import de.hilling.maven.release.versioning.ReleaseInfo;
import de.hilling.maven.release.versioning.SnapshotVersion;
import de.hilling.maven.release.versioning.VersionMatcher;
import java.util.Optional;
import org.apache.maven.project.MavenProject;

class ProjectVersionNamer {
    private final ReleaseInfo previousRelease;
    private final boolean bugfixRelease;
    private final SnapshotVersion currentSnapshot;
    private ImmutableQualifiedArtifact artifact;

    ProjectVersionNamer(MavenProject project, ReleaseInfo previousRelease, boolean bugfixRelease) {
        this.currentSnapshot = new VersionMatcher(project.getVersion()).snapshotVersion();
        this.artifact = ImmutableQualifiedArtifact.builder().groupId(project.getGroupId()).artifactId(project.getArtifactId()).build();
        this.previousRelease = previousRelease;
        this.bugfixRelease = bugfixRelease;
    }

    FixVersion invoke() {
        Optional<ImmutableModuleVersion> previousVersion = this.previousRelease.versionForArtifact(this.artifact);
        this.checkProjectVersion(previousVersion);
        return previousVersion.map(this::followupVersion).orElseGet(this::initialVersion);
    }

    private void checkProjectVersion(Optional<ImmutableModuleVersion> previousVersion) {
        if (previousVersion.isPresent() && previousVersion.get().getVersion().getMajorVersion() > this.currentSnapshot.getMajorVersion()) {
            throw new ValidationException("snapshot version is older than stored previous version");
        }
    }

    private FixVersion initialVersion() {
        if (this.bugfixRelease) {
            throw new ValidationException("Previous build number required when creating bugfix release.");
        }
        return ImmutableFixVersion.builder().majorVersion(this.currentSnapshot.getMajorVersion()).minorVersion(0L).build();
    }

    private FixVersion followupVersion(ModuleVersion previousModule) {
        ImmutableFixVersion.Builder builder = ImmutableFixVersion.builder();
        ImmutableFixVersion previousVersion = previousModule.getVersion();
        builder.from(previousVersion);
        if (this.bugfixRelease) {
            builder.bugfixVersion(((FixVersion)previousVersion).getBugfixVersion().orElse(0L) + 1L);
        } else {
            if (((FixVersion)previousVersion).getBugfixVersion().isPresent()) {
                throw new IllegalStateException("can only create bugfixes from bugfix branch");
            }
            this.selectNextRegularVersion(builder, previousVersion);
        }
        return builder.build();
    }

    private void selectNextRegularVersion(ImmutableFixVersion.Builder builder, FixVersion previousVersion) {
        if (this.currentSnapshot.getMajorVersion() > previousVersion.getMajorVersion()) {
            builder.majorVersion(this.currentSnapshot.getMajorVersion());
            builder.minorVersion(0L);
        } else {
            builder.minorVersion(previousVersion.getMinorVersion() + 1L);
        }
    }
}

