/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.versioning.ImmutableModuleVersion;
import de.hilling.maven.release.versioning.QualifiedArtifact;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ReleaseInfo {
    public abstract Optional<String> getTagName();

    public abstract List<ImmutableModuleVersion> getModules();

    public Optional<ImmutableModuleVersion> versionForArtifact(QualifiedArtifact artifact) {
        return this.getModules().stream().filter(mv -> mv.getArtifact().equals(artifact)).findFirst();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.getTagName().isPresent()) {
            builder.append("tag '").append(this.getTagName().get()).append("' ");
        } else {
            builder.append("(no tag yet) ");
        }
        for (ImmutableModuleVersion moduleVersion : this.getModules()) {
            builder.append(moduleVersion.toString());
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.getModules().isEmpty();
    }
}

