/*
 * Decompiled with CFR 0.152.
 */
package de.hilling.maven.release.versioning;

import de.hilling.maven.release.exceptions.ValidationException;
import de.hilling.maven.release.versioning.ImmutableFixVersion;
import de.hilling.maven.release.versioning.ImmutableSnapshotVersion;
import de.hilling.maven.release.versioning.SnapshotVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionMatcher {
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("^(?<major>\\d+)-SNAPSHOT$");
    private static final Pattern FIX_PATTERN = Pattern.compile("^(?<major>\\d+)\\.(?<minor>\\d+)(\\.(?<bugfix>\\d+))?$");
    private final String version;

    public VersionMatcher(String version) {
        this.version = version;
    }

    public SnapshotVersion snapshotVersion() {
        Matcher matcher = SNAPSHOT_PATTERN.matcher(this.version);
        if (matcher.matches()) {
            ImmutableSnapshotVersion.Builder builder = ImmutableSnapshotVersion.builder();
            return builder.majorVersion(this.fromMatcherGroup(matcher, "major")).build();
        }
        throw new ValidationException("Snapshot version must match " + SNAPSHOT_PATTERN.pattern());
    }

    public long fromMatcherGroup(Matcher matcher, String group) {
        return Long.parseLong(matcher.group(group));
    }

    public ImmutableFixVersion fixVersion() {
        Matcher matcher = FIX_PATTERN.matcher(this.version);
        if (matcher.matches()) {
            ImmutableFixVersion.Builder builder = ImmutableFixVersion.builder();
            builder.majorVersion(this.fromMatcherGroup(matcher, "major"));
            builder.minorVersion(this.fromMatcherGroup(matcher, "minor"));
            if (matcher.group("bugfix") != null) {
                builder.bugfixVersion(this.fromMatcherGroup(matcher, "bugfix"));
            }
            return builder.build();
        }
        throw new ValidationException("Fix version must match " + FIX_PATTERN.pattern());
    }
}

