/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.logback.encoder;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import de.huxhorn.lilith.logback.encoder.LilithEncoderBase;
import de.huxhorn.lilith.logback.encoder.WrappingClassicEncoder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicLilithEncoder
extends LilithEncoderBase<LoggingEvent> {
    private boolean includeCallerData;
    private WrappingClassicEncoder wrappingEncoder = new WrappingClassicEncoder();

    public ClassicLilithEncoder() {
        this.encoder = this.wrappingEncoder;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public void init(OutputStream os) throws IOException {
        super.init(os);
        if (os instanceof ResilientFileOutputStream) {
            ResilientFileOutputStream rfos = (ResilientFileOutputStream)os;
            File file = rfos.getFile();
            if (file.length() == 0L) {
                HashMap<String, String> metaDataMap = new HashMap<String, String>();
                metaDataMap.put("contentType", "logging");
                metaDataMap.put("contentFormat", "protobuf");
                metaDataMap.put("compression", "GZIP");
                this.writeHeader(metaDataMap);
            }
        } else {
            throw new IOException("OutputStream wasn't instanceof ResilientFileOutputStream! " + os);
        }
        this.wrappingEncoder.reset();
    }

    protected void preProcess(LoggingEvent event) {
        if (event != null && this.includeCallerData) {
            event.getCallerData();
        }
    }
}

